package cn.com.duiba.tuia.ssp.center.api.dto.common;

import java.io.Serializable;

/**
 * 〈一句话功能简述〉<br>
 * Description: 基础分页组件
 *
 * @author hillchen
 * @create 2018/10/24 17:31
 */
public class BasePage implements Serializable {
    private static final long serialVersionUID = 8078333308332551516L;
    private final int DEF_PAGE_NO = 1;

    private final int DEF_PAGE_SIZE = 20;

    private int currentPage = DEF_PAGE_NO;

    private int pageSize = DEF_PAGE_SIZE;

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        if(checkPageNo(currentPage)){
            this.currentPage = currentPage;
        }else{
            this.currentPage = DEF_PAGE_NO;
        }
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        if(checkPageSize(pageSize)){
            this.pageSize = pageSize;
        }else{
            this.pageSize = DEF_PAGE_SIZE;
        }

    }

    public void setCanNegativePageSize(Integer pageSize) {
        if(pageSize != null){
            this.pageSize = pageSize;
        }else{
            this.pageSize = DEF_PAGE_SIZE;
        }

    }

    public int getRowStart() {
        return (getCurrentPage() - 1 ) * getPageSize();
    }

    public int getRowEnd() {
        return (getCurrentPage()  * getPageSize()) -1 ;
    }

    private boolean checkPageNo(Integer pageNo){
        return pageNo  != null && pageNo > 0;
    }

    private boolean checkPageSize(Integer pageSize){
        return pageSize  != null && pageSize > 0;
    }
}