package cn.com.duiba.tuia.ssp.center.api.remote.activityTestPlan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.activityTestPlan.ActivityTestProportionDto;
import cn.com.duiba.tuia.ssp.center.api.dto.activityTestPlan.ActivityTestProportionReq;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteActivityTestProportionService {

    /**
     * 查询测试活动比例数据集合
     *
     * @param param
     * @return
     */
    List<ActivityTestProportionDto> queryListByParam(ActivityTestProportionReq param);

    /**
     * 分页查询测试活动比例数据集合
     *
     * @param param
     * @return
     */
    PageResultDto<ActivityTestProportionDto> queryPageListByParam(ActivityTestProportionReq param);

    /**
     * 获取活动关联的活动测试计划状态
     *
     * @param activityIds
     * @return
     */
    Map<String, Integer> getActivityTestSlotMapByActivity(List<Long> activityIds);
}
