package cn.com.duiba.tuia.ssp.center.api.remote.advertselect;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.*;

import java.util.List;

/**
 * 说明:
 *
 * @author hillchen
 * @create 2018-08-03 15:05
 **/
@AdvancedFeignClient
public interface RemoteAdvertSelectService {
    /**
     * 根据查询条件查询广告位屏蔽策略列表
     * @param slotShieldPageQuery
     * @return
     */
    PageResultDto<SlotShieldStrategyPageDto> findSlotShieldStrategyList(SlotShieldPageQuery slotShieldPageQuery);

    /**
     * 初始化
     * @param mediaId
     * @return
     */
    Long initSlotStrategyBySLotAccessType(Long mediaId,Integer slotAccessType);

    /**
     * 根据广告位屏蔽策略id查询广告位屏蔽策略
     * @param id
     * @return
     */
    SlotShieldStrategyDto findSlotShieldStrategy(Long id);

    /**
     * 根据媒体账号id查询app下拉列表
     * @param mediaId
     * @return
     */
    List<MediaAppSelectDto> findSelectMediaAppsBySLotAccessType(Long mediaId,Integer slotAccessType);

    /**
     * 根据appId和媒体广告媒体账号id查询广告位下拉列表
     * @param mediaId
     * @param appId
     * @return
     */
    List<SlotSelectDto> findSelectSlotsBySLotAccessType(Long mediaId,Long appId,Integer slotAccessType);

    /**
     * 根据广告位屏蔽策略查询所有所有可见标签统计信息
     * @param slotStrategyId
     * @return
     */
    List<TagInfoDto> findAllTags(Long slotStrategyId);

    /**
     * 根据广告位屏蔽策略和标签码查询广告列表和标签屏蔽配置信息
     * @param tagAdvertPageQuery
     * @return
     */
    TagShieldInfoDto findAdvertByTag(TagAdvertPageQuery tagAdvertPageQuery);

    boolean saveSlotShieldStrategy(SlotShieldStrategyDto slotShieldStrategy);

    /**
     * @Author zhangliwei
     * @Description  在新建互选策略的时候保存策略并初始化策略下的可见广告以及素材
     * @Date 15:34 2019-08-12
     * @Param [slotShieldStrategy]
     * @return boolean
     **/
    boolean saveAndInitStrategy(SlotShieldStrategyDto slotShieldStrategy);

    TagShieldStrategyResultDto saveTagShieldStrategy(TagShieldStrategyDto tagShieldStrategy);

    Boolean deleteSlotShieldStrategy(Long strategyId);

    /**
     * 根据广告位和appId获取互选广告屏蔽策略配置信息
     * @param slotId
     * @param appId
     * @return
     */
    MediaShieldConfigDto getMediaShieldConfig(Long slotId,Long appId);

    Integer computeStrategyRate(long slotStrategyId);



    /**
     * 初始化
     * @param mediaId
     * @return
     */
    @Deprecated
    Long initSlotStrategy(Long mediaId);


    /**
     * 根据媒体账号id查询app下拉列表
     * @param mediaId
     * @return
     */
    @Deprecated
    List<MediaAppSelectDto> findSelectMediaApps(Long mediaId);


    /**
     * 根据appId和媒体广告媒体账号id查询广告位下拉列表
     * @param mediaId
     * @param appId
     * @return
     */
    @Deprecated
    List<SlotSelectDto> findSelectSlots(Long mediaId,Long appId);
}
