package cn.com.duiba.tuia.ssp.center.api.constant;

/**
  * @Descrption: 素材配置常量
  * @author: miaohongshuai
  * @Date: 2019/7/11
*/
public final class MaterialConstant {
    /** 素材媒体定向开关：开 */
    public static final int MATERIAL_MEDIA_LIMIT_OPEN = 1;
    /** 素材媒体定向开关：关 */
    public static final int MATERIAL_MEDIA_LIMIT_CLOSE = 0;

    /** 广告位素材屏蔽开关：开 */
    public static final int SLOT_SHIELD_MATERIAL_OPEN = 1;
    /** 广告位素材屏蔽开关：关 */
    public static final int SLOT_SHIELD_MATERIAL_CLOSE = 0;

    /** 素材投放开关：开 */
    public static final int MATERIAL_ENABLE = 1;
    /** 素材投放开关：关 */
    public static final int MATERIAL_DISABLE = 0;

    /** 素材定时投放开关：开 */
    public static final int MATERIAL_REGULAR_TIME_OPEN = 1;
    /** 素材定时投放开关：关 */
    public static final int MATERIAL_REGULAR_TIME_CLOSE = 0;

    /** 素材宽度 */
    public static final String PICTURE_WIDTH = "width";

    /** 素材高度 */
    public static final String PICTURE_HEIGHT = "height";

    /** 素材大小 */
    public static final String PICTURE_SIZE = "size";

    /** 广告位素材类型：图文 */
    public static final Integer SLOT_MATERIAL_IMAGE_TEXT = 2;

    /** 素材匹配开关-开，目前补足100张，包含运营手动配置的素材 */
    public static final Integer SLOT_MATERIAL_AUTO_FILL_SIZE = 100;
    /** 素材库中可用在当前广告位的素材需要有50张 */
    public static final Integer SLOT_MATERIAL_CAN_USE_SIZE = 50;
    /** 是否需要根据广告位屏蔽素材过滤 是 **/
    public static final Integer SLOT_SHIELD_FLAG_OPEN = 1;
    /** 是否需要根据广告位屏蔽素材过滤 否 **/
    public static final Integer SLOT_SHIELD_FLAG_CLOSE = 0;
    /** 设置屏蔽素材要校验设置完后开启素材匹配的可用素材大于 4 **/
    public static final Integer SLOT_MATERIAL_ALARM_SIZE = 4;

}
