/**
 * Project Name:ssp-center-api
 * File Name:MediaSlotDailyRecordDto.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2018年1月12日下午3:04:00
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * ClassName:MediaSlotDailyRecordDto <br/>
 * Function: 媒体广告位每日记录. <br/>
 * Date:     2018年1月12日 下午3:04:00 <br/>
 * @author   guyanMediaSlotDailyRecordDto
 * @version  
 * @see 	 
 */
public class MediaSlotDailyRecordDto extends BaseDto {

    /**序列号*/
    private static final long serialVersionUID = -113927461948922476L;
    
    /**媒体ID*/
    private Long appId;
    
    /**广告位ID*/
    private Long slotId;
    
    /**记录日期*/
    private Date curDate;
    
    /**计费方式:0-分成;1-CPC;2-CPM*/
    private Integer chargeType;

    /**广告位类型*/
    private Integer slotType;
    
    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }
    
    public Long getSlotId() {
        return slotId;
    }
    
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }
    
    public Date getCurDate() {
        return curDate;
    }
    
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }
    
    public Integer getChargeType() {
        return chargeType;
    }
    
    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

