/**
 * Project Name:ssp-center-api
 * File Name:BaseStatisticsDataDto.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年9月19日下午2:09:07
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:BaseStatisticsDataDto <br/>
 * Function: 统计基础数据. <br/>
 * Date:     2017年9月19日 下午2:09:07 <br/>
 * @author   guyan
 * @version
 * @since    JDK 1.6
 * @see
 */
public class BaseStatisticsDataDto extends BaseDto implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = -4535000652401398619L;

    /** 入口曝光量 */
    private Long              actExposeCount;
    /** 入口点击量 */
    private Long              actClickCount;
    /** 曝光点击率 */
    private Long              actClickRate;
    /** 入口点击UV */
    private Long              actClickUv;
    /** 活动参与次数 */
    private Long              participateCount;
    /** 活动参与人数 */
    private Long              participateUv;
    /** 参与率 */
    private Long              actParticipateRate;
    /** 复参数 */
    private Long              rptParticipateCount;
    /** 活动点击单价（分） */
    private Long              actPerClickFee;
    /** 每日发券量 */
    private Long              launchCount;
    /** 发券成功率 */
    private Long              launchSuccessRate;
    /** 广告曝光量 */
    private Long              advertExposureCount;
    /** 广告点击量 */
    private Long              advertClickCount;
    /** 广告点击率 */
    private Long              advertClickRate;
    /** 广告点击单价（分） */
    private Long              advertPerClickFee;
    /** 广告收入/广告点击量 */
    private Long              arpu;
    /** 千次曝光产生的发券 */
    private Long              spm;
    /** 千次曝光产生的广告消耗（分） */
    private Long              ecpm;
    /** 广告消耗（分） */
    private Long              adConsume;
    /** 理论广告消耗（分） */
    private Long              logicalConsume;
    /** 媒体预计分成（分） */
    private Long              exConsumeTotal;
    /** 媒体应得分成（分） */
    private Long              consumeTotal;
    /** 当天日期 */
    private Date              curDate;
    /** 入口访问量 */
    private Long              actShowCount;
    /** 活动请求PV */
    private Long              actRequestCount;
    /** 活动请求UV */
    private Long              actRequestUv;
    /** 活动广告券请求 */
    private Long              advertRequestCount;
    /** 请求成功率 */
    private Long              requestSuccessRate;
    /** 广告位有效点击PV */
    private Long              validActClick;
    /** 广告位有效曝光PV */
    private Long              validActExpose;
    /** 活动来源 0：兑吧活动 1：推啊活动 2：流量引导页 */
    private Integer           resource;
    /** 流量引导页访问PV */
    private Long              liuliangPv;
    /** 流量引导页访问UV */
    private Long              liuliangUv;
    /** 广告位访问PV */
    private Long              sdkPv;
    /** 广告位访问UV */
    private Long              sdkUv;
    /** 广告位返回成功PV */
    private Long              actSucResponseCount;
    /**有效点击PV*/
    private Long              efClickCount;
    /**高风险发券量*/
    private Long              highriskLaunch;

    /** 杭州每日广告消耗(分) */
    private Long              hzAdConsume;

    /** 杭州每日媒体预计分成(分） */
    private Long              hzExConsumeTotal;

    /** 杭州每日消费(分) */
    private Long              hzConsumeTotal;

    /** 霍尔果斯每日广告消耗(分) */
    private Long              hegsAdConsume;

    /** 霍尔果斯每日媒体预计分成(分） */
    private Long              hegsExConsumeTotal;

    /** 霍尔果斯每日消费(分) */
    private Long              hegsConsumeTotal;

    /** 霍城兑捷每日广告消耗(分) */
    private Long              hcdjAdConsume;

    /** 霍城兑捷每日媒体预计分成(分） */
    private Long              hcdjExConsumeTotal;

    /** 霍城兑捷每日消费(分) */
    private Long              hcdjConsumeTotal;

    /** 付费券发券量      计费点击日志中，点击单价＞0的广告对应的发券量 */
    private Long              payLaunchPvCount;

    /** 付费券曝光量      计费点击日志中，点击单价＞0的广告对应的曝光量 */
    private Long              payExposurePvCount;

    /** 付费券计费点击量        计费点击日志中，点击单价＞0的广告对应的计费点击量 */
    private Long              payEfClicksCount;

     /*广告位有效访问PV*/
    private Long              slotEfRequestPvCount;

    /* ip访问量*/
    private Long              ipRequestPvCount;

    /*  新客访问量(UV)  */
    private Long              newRequestUvCount;

    /* 广告券请求数(互动) */
    private Long advertRequestCountHd;

    /* 广告券请求数(展示) */
    private Long advertRequestCountZs;

    /* 广告发券量(互动) */
    private Long launchCountHd;

    /* 广告发券量(展示) */
    private Long launchCountZs;

    /* 付费券(互动) */
    private Long payLaunchCountHd;

    /* 付费券(展示) */
    private Long payLaunchCountZs;

    /* 广告券曝光量(互动) */
    private Long advertExposureCountHd;

    /* 广告券曝光量(展示) */
    private Long advertExposureCountZs;

    /* 广告券点击量(互动) */
    private Long advertClickCountHd;

    /* 广告券点击量(展示) */
    private Long advertClickCountZs;

    /* 广告消耗(互动) */
    private Long adConsumeHd;

    /* 广告消耗(展示) */
    private Long adConsumeZs;

    /**
     * 转化pv/有效点击
     */
    private Float cvr;

    /**
     * 现金消耗
     */
    private Long   cashConsume;

    /**
     * 杭州现金消耗
     */
    private Long   hzCashConsume;

    /**
     * 霍尔果斯现金消耗
     */
    private Long   hegsCashConsume;

    /**
     * 霍城兑捷现金消耗
     */
    private Long   hcdjCashConsume;

    /**
     * 广告增值消耗（分）
     */
    private Long valueAddedConsume;


    public Long getCashConsume() {
        return cashConsume;
    }

    public void setCashConsume(Long cashConsume) {
        this.cashConsume = cashConsume;
    }

    public Long getHzCashConsume() {
        return hzCashConsume;
    }

    public void setHzCashConsume(Long hzCashConsume) {
        this.hzCashConsume = hzCashConsume;
    }

    public Long getHegsCashConsume() {
        return hegsCashConsume;
    }

    public void setHegsCashConsume(Long hegsCashConsume) {
        this.hegsCashConsume = hegsCashConsume;
    }

    /**
     * validActClick.
     *
     * @return the validActClick
     * @since JDK 1.6
     */
    public Long getValidActClick() {
        return validActClick;
    }

    /**
     * validActClick.
     *
     * @param validActClick the validActClick to set
     * @since JDK 1.6
     */
    public void setValidActClick(Long validActClick) {
        this.validActClick = validActClick;
    }

    /**
     * validActExpose.
     *
     * @return the validActExpose
     * @since JDK 1.6
     */
    public Long getValidActExpose() {
        return validActExpose;
    }

    /**
     * validActExpose.
     *
     * @param validActExpose the validActExpose to set
     * @since JDK 1.6
     */
    public void setValidActExpose(Long validActExpose) {
        this.validActExpose = validActExpose;
    }

    /**
     * actRequestCount.
     *
     * @return the actRequestCount
     * @since JDK 1.6
     */
    public Long getActRequestCount() {
        return actRequestCount;
    }

    /**
     * actRequestCount.
     *
     * @param actRequestCount the actRequestCount to set
     * @since JDK 1.6
     */
    public void setActRequestCount(Long actRequestCount) {
        this.actRequestCount = actRequestCount;
    }

    /**
     * actRequestUv.
     *
     * @return the actRequestUv
     * @since JDK 1.6
     */
    public Long getActRequestUv() {
        return actRequestUv;
    }

    /**
     * actRequestUv.
     *
     * @param actRequestUv the actRequestUv to set
     * @since JDK 1.6
     */
    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    /**
     * advertRequestCount.
     *
     * @return the advertRequestCount
     * @since JDK 1.6
     */
    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    /**
     * advertRequestCount.
     *
     * @param advertRequestCount the advertRequestCount to set
     * @since JDK 1.6
     */
    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    /**
     * requestSuccessRate.
     *
     * @return the requestSuccessRate
     * @since JDK 1.6
     */
    public Long getRequestSuccessRate() {
        return requestSuccessRate;
    }

    /**
     * requestSuccessRate.
     *
     * @param requestSuccessRate the requestSuccessRate to set
     * @since JDK 1.6
     */
    public void setRequestSuccessRate(Long requestSuccessRate) {
        this.requestSuccessRate = requestSuccessRate;
    }


    /**
     * actExposeCount.
     *
     * @return the actExposeCount
     * @since JDK 1.6
     */
    public Long getActExposeCount() {
        return actExposeCount;
    }

    /**
     * actExposeCount.
     *
     * @param actExposeCount the actExposeCount to set
     * @since JDK 1.6
     */
    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    /**
     * actClickCount.
     *
     * @return the actClickCount
     * @since JDK 1.6
     */
    public Long getActClickCount() {
        return actClickCount;
    }

    /**
     * actClickCount.
     *
     * @param actClickCount the actClickCount to set
     * @since JDK 1.6
     */
    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    /**
     * actClickRate.
     *
     * @return the actClickRate
     * @since JDK 1.6
     */
    public Long getActClickRate() {
        return actClickRate;
    }

    /**
     * actClickRate.
     *
     * @param actClickRate the actClickRate to set
     * @since JDK 1.6
     */
    public void setActClickRate(Long actClickRate) {
        this.actClickRate = actClickRate;
    }

    /**
     * actClickUv.
     *
     * @return the actClickUv
     * @since JDK 1.6
     */
    public Long getActClickUv() {
        return actClickUv;
    }

    /**
     * actClickUv.
     *
     * @param actClickUv the actClickUv to set
     * @since JDK 1.6
     */
    public void setActClickUv(Long actClickUv) {
        this.actClickUv = actClickUv;
    }

    /**
     * participateCount.
     *
     * @return the participateCount
     * @since JDK 1.6
     */
    public Long getParticipateCount() {
        return participateCount;
    }

    /**
     * participateCount.
     *
     * @param participateCount the participateCount to set
     * @since JDK 1.6
     */
    public void setParticipateCount(Long participateCount) {
        this.participateCount = participateCount;
    }

    /**
     * participateUv.
     *
     * @return the participateUv
     * @since JDK 1.6
     */
    public Long getParticipateUv() {
        return participateUv;
    }

    /**
     * participateUv.
     *
     * @param participateUv the participateUv to set
     * @since JDK 1.6
     */
    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    /**
     * actParticipateRate.
     *
     * @return the actParticipateRate
     * @since JDK 1.6
     */
    public Long getActParticipateRate() {
        return actParticipateRate;
    }

    /**
     * actParticipateRate.
     *
     * @param actParticipateRate the actParticipateRate to set
     * @since JDK 1.6
     */
    public void setActParticipateRate(Long actParticipateRate) {
        this.actParticipateRate = actParticipateRate;
    }

    /**
     * rptParticipateCount.
     *
     * @return the rptParticipateCount
     * @since JDK 1.6
     */
    public Long getRptParticipateCount() {
        return rptParticipateCount;
    }

    /**
     * rptParticipateCount.
     *
     * @param rptParticipateCount the rptParticipateCount to set
     * @since JDK 1.6
     */
    public void setRptParticipateCount(Long rptParticipateCount) {
        this.rptParticipateCount = rptParticipateCount;
    }

    /**
     * actPerClickFee.
     *
     * @return the actPerClickFee
     * @since JDK 1.6
     */
    public Long getActPerClickFee() {
        return actPerClickFee;
    }

    /**
     * actPerClickFee.
     *
     * @param actPerClickFee the actPerClickFee to set
     * @since JDK 1.6
     */
    public void setActPerClickFee(Long actPerClickFee) {
        this.actPerClickFee = actPerClickFee;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * launchSuccessRate.
     *
     * @return the launchSuccessRate
     * @since JDK 1.6
     */
    public Long getLaunchSuccessRate() {
        return launchSuccessRate;
    }

    /**
     * launchSuccessRate.
     *
     * @param launchSuccessRate the launchSuccessRate to set
     * @since JDK 1.6
     */
    public void setLaunchSuccessRate(Long launchSuccessRate) {
        this.launchSuccessRate = launchSuccessRate;
    }

    /**
     * advertExposureCount.
     *
     * @return the advertExposureCount
     * @since JDK 1.6
     */
    public Long getAdvertExposureCount() {
        return advertExposureCount;
    }

    /**
     * advertExposureCount.
     *
     * @param advertExposureCount the advertExposureCount to set
     * @since JDK 1.6
     */
    public void setAdvertExposureCount(Long advertExposureCount) {
        this.advertExposureCount = advertExposureCount;
    }

    /**
     * advertClickCount.
     *
     * @return the advertClickCount
     * @since JDK 1.6
     */
    public Long getAdvertClickCount() {
        return advertClickCount;
    }

    /**
     * advertClickCount.
     *
     * @param advertClickCount the advertClickCount to set
     * @since JDK 1.6
     */
    public void setAdvertClickCount(Long advertClickCount) {
        this.advertClickCount = advertClickCount;
    }

    /**
     * advertClickRate.
     *
     * @return the advertClickRate
     * @since JDK 1.6
     */
    public Long getAdvertClickRate() {
        return advertClickRate;
    }

    /**
     * advertClickRate.
     *
     * @param advertClickRate the advertClickRate to set
     * @since JDK 1.6
     */
    public void setAdvertClickRate(Long advertClickRate) {
        this.advertClickRate = advertClickRate;
    }

    /**
     * advertPerClickFee.
     *
     * @return the advertPerClickFee
     * @since JDK 1.6
     */
    public Long getAdvertPerClickFee() {
        return advertPerClickFee;
    }

    /**
     * advertPerClickFee.
     *
     * @param advertPerClickFee the advertPerClickFee to set
     * @since JDK 1.6
     */
    public void setAdvertPerClickFee(Long advertPerClickFee) {
        this.advertPerClickFee = advertPerClickFee;
    }

    /**
     * arpu.
     *
     * @return the arpu
     * @since JDK 1.6
     */
    public Long getArpu() {
        return arpu;
    }

    /**
     * arpu.
     *
     * @param arpu the arpu to set
     * @since JDK 1.6
     */
    public void setArpu(Long arpu) {
        this.arpu = arpu;
    }

    /**
     * spm.
     *
     * @return the spm
     * @since JDK 1.6
     */
    public Long getSpm() {
        return spm;
    }

    /**
     * spm.
     *
     * @param spm the spm to set
     * @since JDK 1.6
     */
    public void setSpm(Long spm) {
        this.spm = spm;
    }

    /**
     * ecpm.
     *
     * @return the ecpm
     * @since JDK 1.6
     */
    public Long getEcpm() {
        return ecpm;
    }

    /**
     * ecpm.
     *
     * @param ecpm the ecpm to set
     * @since JDK 1.6
     */
    public void setEcpm(Long ecpm) {
        this.ecpm = ecpm;
    }

    /**
     * adConsume.
     *
     * @return the adConsume
     * @since JDK 1.6
     */
    public Long getAdConsume() {
        return adConsume;
    }

    /**
     * adConsume.
     *
     * @param adConsume the adConsume to set
     * @since JDK 1.6
     */
    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume;
    }

    public Long getLogicalConsume() {
        return logicalConsume;
    }

    public void setLogicalConsume(Long logicalConsume) {
        this.logicalConsume = logicalConsume;
    }

    /**
     * exConsumeTotal.
     *
     * @return the exConsumeTotal
     * @since JDK 1.6
     */
    public Long getExConsumeTotal() {
        return exConsumeTotal;
    }

    /**
     * exConsumeTotal.
     *
     * @param exConsumeTotal the exConsumeTotal to set
     * @since JDK 1.6
     */
    public void setExConsumeTotal(Long exConsumeTotal) {
        this.exConsumeTotal = exConsumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * actShowCount.
     *
     * @return the actShowCount
     * @since JDK 1.6
     */
    public Long getActShowCount() {
        return actShowCount;
    }

    /**
     * actShowCount.
     *
     * @param actShowCount the actShowCount to set
     * @since JDK 1.6
     */
    public void setActShowCount(Long actShowCount) {
        this.actShowCount = actShowCount;
    }

    /**
     * resource.
     *
     * @return the resource
     * @since JDK 1.6
     */
    public Integer getResource() {
        return resource;
    }

    /**
     * resource.
     *
     * @param resource the resource to set
     * @since JDK 1.6
     */
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    /**
     * liuliangPv.
     *
     * @return the liuliangPv
     * @since JDK 1.6
     */
    public Long getLiuliangPv() {
        return liuliangPv;
    }

    /**
     * liuliangPv.
     *
     * @param liuliangPv the liuliangPv to set
     * @since JDK 1.6
     */
    public void setLiuliangPv(Long liuliangPv) {
        this.liuliangPv = liuliangPv;
    }

    /**
     * liuliangUv.
     *
     * @return the liuliangUv
     * @since JDK 1.6
     */
    public Long getLiuliangUv() {
        return liuliangUv;
    }

    /**
     * liuliangUv.
     *
     * @param liuliangUv the liuliangUv to set
     * @since JDK 1.6
     */
    public void setLiuliangUv(Long liuliangUv) {
        this.liuliangUv = liuliangUv;
    }

    /**
     * sdkPv.
     *
     * @return the sdkPv
     * @since JDK 1.6
     */
    public Long getSdkPv() {
        return sdkPv;
    }

    /**
     * sdkPv.
     *
     * @param sdkPv the sdkPv to set
     * @since JDK 1.6
     */
    public void setSdkPv(Long sdkPv) {
        this.sdkPv = sdkPv;
    }

    /**
     * sdkUv.
     *
     * @return the sdkUv
     * @since JDK 1.6
     */
    public Long getSdkUv() {
        return sdkUv;
    }

    /**
     * sdkUv.
     *
     * @param sdkUv the sdkUv to set
     * @since JDK 1.6
     */
    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    /**
     * actSucResponseCount.
     *
     * @return the actSucResponseCount
     * @since JDK 1.6
     */
    public Long getActSucResponseCount() { return actSucResponseCount; }

    /**
     * actSucResponseCount.
     *
     * @param actSucResponseCount the actSucResponseCount to set
     * @since JDK 1.6
     */
    public void setActSucResponseCount(Long actSucResponseCount) { this.actSucResponseCount = actSucResponseCount; }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * highriskLaunch.
     *
     * @return the highriskLaunch
     * @since JDK 1.6
     */
    public Long getHighriskLaunch() {
        return highriskLaunch;
    }

    /**
     * highriskLaunch.
     *
     * @param highriskLaunch the highriskLaunch to set
     * @since JDK 1.6
     */
    public void setHighriskLaunch(Long highriskLaunch) {
        this.highriskLaunch = highriskLaunch;
    }


    public Long getHzAdConsume() {
        return hzAdConsume;
    }


    public void setHzAdConsume(Long hzAdConsume) {
        this.hzAdConsume = hzAdConsume;
    }


    public Long getHzExConsumeTotal() {
        return hzExConsumeTotal;
    }


    public void setHzExConsumeTotal(Long hzExConsumeTotal) {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }


    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }


    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }


    public Long getHegsAdConsume() {
        return hegsAdConsume;
    }


    public void setHegsAdConsume(Long hegsAdConsume) {
        this.hegsAdConsume = hegsAdConsume;
    }


    public Long getHegsExConsumeTotal() {
        return hegsExConsumeTotal;
    }


    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }


    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }


    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }


    public Long getPayLaunchPvCount() {
        return payLaunchPvCount;
    }


    public void setPayLaunchPvCount(Long payLaunchPvCount) {
        this.payLaunchPvCount = payLaunchPvCount;
    }


    public Long getPayExposurePvCount() {
        return payExposurePvCount;
    }


    public void setPayExposurePvCount(Long payExposurePvCount) {
        this.payExposurePvCount = payExposurePvCount;
    }


    public Long getPayEfClicksCount() {
        return payEfClicksCount;
    }


    public void setPayEfClicksCount(Long payEfClicksCount) {
        this.payEfClicksCount = payEfClicksCount;
    }


    public Long getSlotEfRequestPvCount() {
        return slotEfRequestPvCount;
    }


    public void setSlotEfRequestPvCount(Long slotEfRequestPvCount) {
        this.slotEfRequestPvCount = slotEfRequestPvCount;
    }


    public Long getIpRequestPvCount() {
        return ipRequestPvCount;
    }


    public void setIpRequestPvCount(Long ipRequestPvCount) {
        this.ipRequestPvCount = ipRequestPvCount;
    }


    public Long getNewRequestUvCount() {
        return newRequestUvCount;
    }


    public void setNewRequestUvCount(Long newRequestUvCount) {
        this.newRequestUvCount = newRequestUvCount;
    }

    public Long getAdvertRequestCountHd() {
        return advertRequestCountHd;
    }

    public void setAdvertRequestCountHd(Long advertRequestCountHd) {
        this.advertRequestCountHd = advertRequestCountHd;
    }

    public Long getAdvertRequestCountZs() {
        return advertRequestCountZs;
    }

    public void setAdvertRequestCountZs(Long advertRequestCountZs) {
        this.advertRequestCountZs = advertRequestCountZs;
    }

    public Long getLaunchCountHd() {
        return launchCountHd;
    }

    public void setLaunchCountHd(Long launchCountHd) {
        this.launchCountHd = launchCountHd;
    }

    public Long getLaunchCountZs() {
        return launchCountZs;
    }

    public void setLaunchCountZs(Long launchCountZs) {
        this.launchCountZs = launchCountZs;
    }

    public Long getPayLaunchCountHd() {
        return payLaunchCountHd;
    }

    public void setPayLaunchCountHd(Long payLaunchCountHd) {
        this.payLaunchCountHd = payLaunchCountHd;
    }

    public Long getPayLaunchCountZs() {
        return payLaunchCountZs;
    }

    public void setPayLaunchCountZs(Long payLaunchCountZs) {
        this.payLaunchCountZs = payLaunchCountZs;
    }

    public Long getAdvertExposureCountHd() {
        return advertExposureCountHd;
    }

    public void setAdvertExposureCountHd(Long advertExposureCountHd) {
        this.advertExposureCountHd = advertExposureCountHd;
    }

    public Long getAdvertExposureCountZs() {
        return advertExposureCountZs;
    }

    public void setAdvertExposureCountZs(Long advertExposureCountZs) {
        this.advertExposureCountZs = advertExposureCountZs;
    }

    public Long getAdvertClickCountHd() {
        return advertClickCountHd;
    }

    public void setAdvertClickCountHd(Long advertClickCountHd) {
        this.advertClickCountHd = advertClickCountHd;
    }

    public Long getAdvertClickCountZs() {
        return advertClickCountZs;
    }

    public void setAdvertClickCountZs(Long advertClickCountZs) {
        this.advertClickCountZs = advertClickCountZs;
    }

    public Long getAdConsumeHd() {
        return adConsumeHd;
    }

    public void setAdConsumeHd(Long adConsumeHd) {
        this.adConsumeHd = adConsumeHd;
    }

    public Long getAdConsumeZs() {
        return adConsumeZs;
    }

    public void setAdConsumeZs(Long adConsumeZs) {
        this.adConsumeZs = adConsumeZs;
    }

    public Long getHcdjAdConsume() {
        return hcdjAdConsume;
    }

    public void setHcdjAdConsume(final Long hcdjAdConsume) {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjExConsumeTotal() {
        return hcdjExConsumeTotal;
    }

    public void setHcdjExConsumeTotal(final Long hcdjExConsumeTotal) {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjConsumeTotal() {
        return hcdjConsumeTotal;
    }

    public void setHcdjConsumeTotal(final Long hcdjConsumeTotal) {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHcdjCashConsume() {
        return hcdjCashConsume;
    }

    public void setHcdjCashConsume(final Long hcdjCashConsume) {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Float getCvr() {
        return cvr;
    }

    public void setCvr(Float cvr) {
        this.cvr = cvr;
    }

    public Long getValueAddedConsume() {
        return valueAddedConsume;
    }

    public void setValueAddedConsume(Long valueAddedConsume) {
        this.valueAddedConsume = valueAddedConsume;
    }
}

