/**
 * Project Name:ssp-center-api
 * File Name:RemoteStrategyService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年6月6日上午10:55:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ManagerShieldStrategyDto;
import cn.com.duiba.tuia.ssp.center.api.dto.StrategyCacheDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteStrategyService <br/>
 * Function: 管理端屏蔽策略. <br/>
 * Date:     2017年6月6日 上午10:55:20 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteManagerShieldStrategyService {

    /**
     * 
     * insert:(新增屏蔽标签). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> insert(ManagerShieldStrategyDto param);
    
    /**
     * 
     * update:(修改屏蔽标签). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> update(ManagerShieldStrategyDto param);
    
   
    DubboResult<ManagerShieldStrategyDto> selectById(Long id);

    /**
     * 
     * selectBySlotId:(通过广告位ID查询管理端屏蔽标签). <br/>
     *
     * @author guyan
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<ManagerShieldStrategyDto> selectBySlotId(Long slotId);

	/**
     * 通过广告位ID查询管理端屏蔽策略
	 * @param slotId
	 * @return StrategyCacheDto（需要AppId）
	 */
	StrategyCacheDto queryStrategyBySlotId(Long slotId);

    /**
     * (百奇需求使用http://cf.dui88.com/pages/viewpage.action?pageId=9765380)
     * 通过广告位ID查询管理端屏蔽策略
     *
     * @param slotId
     * @return StrategyCacheDto
     */
    StrategyCacheDto queryStrategyNameBySlotId(Long slotId);

    /**
     * 通过广告位ID查询管理端活动屏蔽标签
     *
     * @param slotId 广告位id
     * @return 活动屏蔽标签
     */
    List<String> getActShieldStrategy(Long slotId);


    List<ManagerShieldStrategyDto> selectBySlotIds(List<Long> slotIds);

    void updateManagerShieldStrategyDataBySlotId(List<String> tagList,Long slotId);

    /**
     * @Author zhangliwei
     * @Description  更新广告位屏蔽策略前置校验,判断素材标签和落地页标签中相同文本的标签选中状态是否一致
     * @Date 16:07 2019-09-26
     * @Param [param]
     * @return cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Boolean>
     **/
    Boolean checkTags(ManagerShieldStrategyDto param);

}

