/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import cn.com.duiba.tuia.ssp.center.api.constant.SSPErrorCode;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.tool.ExecuteCallBack;
import cn.com.duiba.tuia.ssp.center.api.tool.StackTraceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExcuteTemplateHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteExcuteTemplateHandle.class);

    public static <T> Result<T> execute(ExecuteCallBack<T> callBack, Logger logger, String reqJsonString) {
        try {
            return callBack.process();
        }
        catch (Exception e) {
            return RemoteExcuteTemplateHandle.handleException(e, logger, reqJsonString);
        }
    }

    private static <T> Result<T> handleException(Exception e, Logger logger, String reqJsonString) {
        try {
            String message = e.getMessage();
            message = message.substring(message.indexOf("message") + 10, message.indexOf("timestamp") - 3);
            String methodName = StackTraceUtil.getCallMethodName(2);
            logger.error(methodName + " \u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570:{}, errorMsg:{}", new Object[]{reqJsonString, message, e});
            return Result.error(SSPErrorCode.SSP_111111.getCode(), message);
        }
        catch (Throwable throwable) {
            LOGGER.error("handleException throwable", (Throwable)e);
            return Result.error(SSPErrorCode.SSP_111111);
        }
    }
}

