package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 素材匹配广告位请求参数
 *
 * @author zhangzhenghe
 * @since 2020-02-04 11:15 AM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReqMaterialMatchSlot extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -4861938144135272249L;

    /**
     * 素材ID
     */
    private Long id;

    /**
     * 缩放比例(1: 10%*10% 2: 20%*20% 3:30%*30% 4:40%*40%  5: 50%*50% 6:广告位规格长宽等比)
     */
    private Integer zoomSize;

    /**
     * 自定义长宽缩放比例 宽度
     */
    private Integer widthSize;

    /**
     * 自定义长宽缩放比例 高度
     */
    private Integer heightSize;

    /**
     * 高度比例上限
     */
    private Double heightUpFlot;

    /**
     * 高度比例下限
     */
    private Double heightDownFlot;

    /**
     * 宽度比例上限
     */
    private Double widthUpFlot;

    /**
     * 宽度比例下限
     */
    private Double widthDownFlot;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 素材高度
     */
    private Integer imageHeight;

    /**
     * 素材宽度
     */
    private Integer imageWidth;

    /**
     * 规格ID列表
     */
    private List<Long> msIds;
}
