package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 优选素材响应结果
 *
 * @author zhangzhenghe
 * @since 2020-02-04 11:11 AM
 */
@Data
public class RspMaterialFavorite implements Serializable {

    private static final long serialVersionUID = 5494330067999796137L;

    /**
     * 素材ID
     */
    private Long id;

    /**
     * 素材名称
     */
    private String title;

    /**
     * 素材图片
     */
    private String content;

    /**
     * 适用场景
     */
    private List<String> tagTitles;

    /**
     * 是否开启(1:开启 0:关闭)
     */
    private Integer enableStatus;

    /**
     * 策划人
     */
    private String designer;

    /**
     * 尺寸
     */
    private String pictureVal;

    /**
     * 发布时间
     */
    private Date gmtCreate;

    /**
     * 曝光PV
     */
    private Long exposeCount;

    /**
     * CTR
     */
    private Double ctr;

    /**
     * 上线广告位个数
     */
    private Integer slotNum;

    /**
     * 是否收藏(1:已收藏 0:未收藏)
     */
    private Integer favoriteStatus;

    /**
     * 规格ID
     */
    private Long msId;

    /**
     * 规格名称
     */
    private String msName;
}
