package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import java.io.Serializable;

/**
 * @author fangzhipeng
 * @date 2018/9/18
 */
public class ConsumeSlot implements Serializable {

    private static final long serialVersionUID = 7950418083846948801L;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 媒体收益
     */
    private Long consumeTotal;

    public ConsumeSlot() {}

    public ConsumeSlot(String slotName, Long consumeTotal) {
        this.slotName = slotName;
        this.consumeTotal = consumeTotal;
    }

    public ConsumeSlot(Long slotId, String slotName, Long consumeTotal) {
        this.slotId = slotId;
        this.slotName = slotName;
        this.consumeTotal = consumeTotal;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public ConsumeSlot merge(ConsumeSlot other) {
        this.consumeTotal = this.consumeTotal + other.getConsumeTotal();
        return this;
    }
}
