package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqDomainInfo;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDomainConfigService {

    DubboResult<Integer> update(DomainConfigDto domainConfigDto);

    DubboResult<DomainConfigDto> insert(DomainConfigDto domainConfigDto);

    DubboResult<Integer> deleteById(Long id);

    DubboResult<List<DomainConfigDto>> selectList();

    List<DomainConfigDto> selectListByLimit(ReqDomainInfo req);

    Integer selectListCountByLimit(ReqDomainInfo req);

    /**
     * 通过媒体ID查找媒体对应的域名策略
     *
     * @param appId
     * @return
     */
    DomainConfigDto selectByAppId(Long appId);

}
