/**
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ExcellentActivityDto;

import java.util.List;

/**
 * @Description:
 * @Date: 2019/8/27
 * @author: miaohongshuai
 **/
@AdvancedFeignClient
public interface RemoteExcellentActivityService {

    /**
     * 根据创建时间的时间范围查询 优质活动列表
     * @param beginTime 开始时间
     * @param endTime 结束时间
     * @return 优质活动列表
     */
    List<ExcellentActivityDto> listExcellentActivityByTime(String beginTime, String endTime);

}
