package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Date;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MeidaActivitySlotStatisticsHourDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActAppStatHour;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivityHourStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivitySoltHourDataByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAppHourStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAppSlotHourStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotStatHour;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteMediaActivitySlotStatisticsHourService {
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectSlotHourData(ReqSlotStatHour req);

    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectAppHourData (ReqAppHourStatistics req);

    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectAppSlotHourData(ReqAppSlotHourStatistics req);
    
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectActivityHourData(ReqActivityHourStatistics param);

    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectActivitySoltHourData(ReqActivitySoltHourDataByPage param);

    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectActAppHourData(ReqActAppStatHour param);
    
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectSlotHourSumData(ReqSlotStatHour req);
    
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectAppHourSumData (ReqAppHourStatistics req);
    
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectAppSlotHourSumData(ReqAppSlotHourStatistics req);
    
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectActivitySoltHourSumData(ReqActivitySoltHourDataByPage param);
    
    DubboResult<List<MeidaActivitySlotStatisticsHourDto>> selectActAppHourSumData(ReqActAppStatHour param);

    /**
     * 提供给活动系统
     * 查询媒体时段广告消耗 此接口查询无结果会返回Null
     * @param appId 应用ID
     * @param start 开始时间
     * @param end   结束时间
     * @return      广告消耗
     */
    DubboResult<Long> selectAppEarnByDate(Long appId, Date start, Date end);
}
