package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PrizeTagDTO;

import java.util.List;

/**
 * 奖品标签服务
 * @author miaohongshuai
*/
@AdvancedFeignClient
public interface RemotePrizeTagService {

    /**
     * 根据奖品id删除奖品标签
     * @param prizeId
     * @return
     */
    int deleteByPrizeId(Long prizeId);
    /**
     * 保存奖品标签列表
     * @param prizeId
     * @param tags
     * @return
     */
    int savePrizeTags(Long prizeId, List<Long> tags);

    /**
     * 根据奖品id获取标签列表
     * @param prizeId
     * @return
     */
    List<Long> listByPrizeId(Long prizeId);

    /**
     * 根据奖品id列表查询 奖品标签关联DTO
     * @param prizeIds
     * @return
     */
    List<PrizeTagDTO> listDTOByPrizeIds(List<Long> prizeIds);
}
