package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 流量调整数据同步
 */
@Data
public class SlotFlowSyncDataDTO implements Serializable {

    private static final Long serialVersionUID = 1210834971551059929L;

    /**
     * 媒体用户id
     */
    private Long mediaId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用所属平台
     */
    private String platform;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 广告位名
     */
    private String slotName;

    /**
     * 广告位类型
     */
    private Integer slotType;

    /**
     * 广告位规格ID
     */
    private Long slotMsId;

    /**
     * 入口曝光量
     */
    private Long actExposeCount;

    /**
     * 入口点击量
     */
    private Long actClickCount;

    /**
     * 入口点击UV
     */
    private Long actClickUv;

    /**
     * 入口点击率
     */
    private Long actClickRate;

    /**
     * 活动请求UV
     */
    private Long actRequestUv;

    /**
     * 活动请求PV
     */
    private Long actRequestCount;

    /**
     * 活动参与次数
     */
    private Long participateCount;

    /**
     * 活动参与人数
     */
    private Long participateUv;

    /**
     * 参与率
     */
    private Long actParticipateRate;

    /**
     * 复参数
     */
    private Long rptParticipateCount;

    /**
     * 活动广告券请求
     */
    private Long advertRequestCount;

    /**
     * 每日发券量
     */
    private Long launchCount;

    /**
     * 请求成功率
     */
    private Long requestSuccessRate;

    /**
     * 发券成功率
     */
    private Long launchSuccessRate;

    /**
     * 广告曝光量 
     */
    private Long advertExposureCount;

    /**
     * 广告点击量
     */
    private Long advertClickCount;

    /**
     * 广告点击率
     */
    private Long advertClickRate;

    /**
     * 广告点击单价(分)
     */
    private Long advertPerClickFee;

    /**
     * 广告收入/广告点击量
     */
    private Long arpu;

    /**
     * 千次曝光产生的发券
     */
    private Long spm;

    /**
     * 千次曝光产生的广告消耗（分）
     */
    private Long ecpm;

    /**
     * 活动UV单价（分）
     */
    private Long actPerRequestFee;

    /**
     * 活动点击单价（分）
     */
    private Long actPerClickFee;

    /**
     * 广告消耗（分）
     */
    private Long adConsume;

    /**
     * 媒体预计分成（分）
     */
    private Long exConsumeTotal;

    /**
     * 媒体应得分成（分）
     */
    private Long consumeTotal;

    /**
     * 当天日期
     */
    private Date curDate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 有效点击次数
     */
    private Long efClickCount;

    /**
     * 有效点击UV
     */
    private Long advertClickCountUv;

    /**
     * 流量引导页访问PV
     */
    private Long liuliangPv;

    /**
     * 流量引导页访问UV
     */
    private Long liuliangUv;

    /**
     * 广告位访问PV
     */
    private Long sdkPv;

    /**
     * 广告位访问UV
     */
    private Long sdkUv;

    /**
     * 活动来源 0：兑吧活动  1：推啊活动  2：流量引导页
     */
    private Integer resource;

    /**
     * 广告位返回成功PV
     */
    private Long actSucResponseCount;

    /**
     * 高风险发券量
     */
    private Long highriskLaunch;

    /**
     * 媒体预计分成按分存储
     */
    private Long mediaExDivide;

    /**
     * 媒体应得分成按分存储
     */
    private Long mediaDueDivide;

    /**
     * 理论广告消耗（分）
     */
    private Long logicalConsume;

    /**
     * 广告位曝光uv
     */
    private Long actExposeUv;

    /**
     * 杭州每日广告消耗(分)
     */
    private Long hzAdConsume;

    /**
     * 霍尔果斯每日广告消耗(分)
     */
    private Long hegsAdConsume;

    /**
     * 杭州每日媒体预计分成(分）
     */
    private Long hzExConsumeTotal;

    /**
     * 霍尔果斯每日媒体预计分成(分）
     */
    private Long hegsExConsumeTotal;

    /**
     * 杭州每日消费(分)
     */
    private Long hzConsumeTotal;

    /**
     * 霍尔果斯每日消费(分)
     */
    private Long hegsConsumeTotal;

    /**
     * 杭州媒体预计分成按分存储
     */
    private Long hzMediaExDivide;

    /**
     * 霍尔果斯媒体预计分成按分存储
     */
    private Long hegsMediaExDivide;

    /**
     * 杭州媒体应得分成按分存储
     */
    private Long hzMediaDueDivide;

    /**
     * 霍尔果斯媒体应得分成按分存储
     */
    private Long hegsMediaDueDivide;

    /**
     * 付费券发券量      计费点击日志中，点击单价＞0的广告对应的发券量
     */
    private Long payLaunchPv;

    /**
     * 付费券曝光量      计费点击日志中，点击单价＞0的广告对应的曝光量
     */
    private Long payExposurePv;

    /**
     * 付费券计费点击量        计费点击日志中，点击单价＞0的广告对应的计费点击量
     */
    private Long payEfClicks;

    /**
     * ip访问量
     */
    private Long ipRequestPv;

    /**
     * 广告位有效访问pv
     */
    private Long slotEfRequestPv;

    /**
     * 新客访问量
     */
    private Long newRequestUv;

    /**
     * 广告券请求数（互动）
     */
    private Long advertRequestCountHd;

    /**
     * 广告券请求数（展示）
     */
    private Long advertRequestCountZs;

    /**
     * 广告发券量（互动）
     */
    private Long launchCountHd;

    /**
     * 广告发券量（展示）
     */
    private Long launchCountZs;

    /**
     * 付费券发券量（互动）
     */
    private Long payLaunchHd;

    /**
     * 付费券发券量（展示）
     */
    private Long payLaunchZs;

    /**
     * 广告券曝光量（互动）
     */
    private Long advertExposureCountHd;

    /**
     * 广告券曝光量（展示）
     */
    private Long advertExposureCountZs;

    /**
     * 广告券点击量（互动）
     */
    private Long advertClickCountHd;

    /**
     * 广告券点击量（展示）
     */
    private Long advertClickCountZs;

    /**
     * 广告消耗（互动）
     */
    private Long adConsumeHd;

    /**
     * 广告消耗（展示）
     */
    private Long adConsumeZs;

    /**
     * 接入广告类型 0-互动广告 1-展示广告
     */
    private Integer slotAccessType;

    /**
     * 现金消耗(分)
     */
    private Long cashConsume;

    /**
     * 杭州现金消耗(分)
     */
    private Long hzCashConsume;

    /**
     * 霍尔果斯现金消耗(分)
     */
    private Long hegsCashConsume;

    /**
     * 霍城兑捷每日广告消耗(分)
     */
    private Long hcdjAdConsume;

    /**
     * 霍城兑捷每日媒体预计分成(分）
     */
    private Long hcdjExConsumeTotal;

    /**
     * 霍城兑捷每日消费(分)
     */
    private Long hcdjConsumeTotal;

    /**
     * 霍城兑捷媒体预计分成按分存储
     */
    private Long hcdjMediaExDivide;

    /**
     * 霍城兑捷媒体应得分成按分存储
     */
    private Long hcdjMediaDueDivide;

    /**
     * 霍城兑捷现金消耗(分)
     */
    private Long hcdjCashConsume;

    /**
     * 请求 serving 次数
     */
    private Long requestCount;

    /**
     * 下发 serving 成功返回次数
     */
    private Long sendCount;

    /**
     * 调整后广告消耗（分）
     */
    private Long adConsumeNew;

    /**
     * 调整后媒体预计分成（分）
     */
    private Long exConsumeTotalNew;

    /**
     * 调整后媒体应得分成（分）
     */
    private Long consumeTotalNew;

    /**
     * 调整后媒体预计分成按分存储
     */
    private Long mediaExDivideNew;

    /**
     * 调整后媒体应得分成按分存储
     */
    private Long mediaDueDivideNew;

    /**
     * 调整后杭州每日广告消耗(分)
     */
    private Long hzAdConsumeNew;

    /**
     * 调整后霍尔果斯每日广告消耗(分)
     */
    private Long hegsAdConsumeNew;

    /**
     * 调整后杭州每日媒体预计分成(分）
     */
    private Long hzExConsumeTotalNew;

    /**
     * 调整后霍尔果斯每日媒体预计分成(分）
     */
    private Long hegsExConsumeTotalNew;

    /**
     * 调整后杭州每日消费(分)
     */
    private Long hzConsumeTotalNew;

    /**
     * 调整后霍尔果斯每日消费(分)
     */
    private Long hegsConsumeTotalNew;

    /**
     * 调整后杭州媒体预计分成按分存储
     */
    private Long hzMediaExDivideNew;

    /**
     * 调整后霍尔果斯媒体预计分成按分存储
     */
    private Long hegsMediaExDivideNew;

    /**
     * 调整后杭州媒体应得分成按分存储
     */
    private Long hzMediaDueDivideNew;

    /**
     * 调整后霍尔果斯媒体应得分成按分存储
     */
    private Long hegsMediaDueDivideNew;

    /**
     * 调整后广告消耗（互动）
     */
    private Long adConsumeHdNew;

    /**
     * 调整后广告消耗（展示）
     */
    private Long adConsumeZsNew;

    /**
     * 调整后现金消耗(分)
     */
    private Long cashConsumeNew;

    /**
     * 调整后杭州现金消耗(分)
     */
    private Long hzCashConsumeNew;

    /**
     * 调整后霍尔果斯现金消耗(分)
     */
    private Long hegsCashConsumeNew;

    /**
     * 调整后霍城兑捷每日广告消耗(分)
     */
    private Long hcdjAdConsumeNew;

    /**
     * 调整后霍城兑捷每日媒体预计分成(分）
     */
    private Long hcdjExConsumeTotalNew;

    /**
     * 调整后霍城兑捷每日消费(分)
     */
    private Long hcdjConsumeTotalNew;

    /**
     * 调整后霍城兑捷媒体预计分成按分存储
     */
    private Long hcdjMediaExDivideNew;

    /**
     * 调整后霍城兑捷媒体应得分成按分存储
     */
    private Long hcdjMediaDueDivideNew;

    /**
     * 调整后霍城兑捷现金消耗(分)
     */
    private Long hcdjCashConsumeNew;

    /**
     * 调整后广告位访问UV
     */
    private Long sdkUvNew;

    /**
     * 调整后广告位有效访问pv
     */
    private Long slotEfRequestPvNew;

    /**
     * 调整后新客访问量
     */
    private Long newRequestUvNew;

    /**
     * 调整后ip访问量
     */
    private Long ipRequestPvNew;

    /**
     * 增值消耗
     */
    private Long encConsumeTotal;

    /**
     * 调整后增值消耗
     */
    private Long encConsumeTotalNew;

    /**
     * 原有增值消耗
     */
    private Long encConsumeTotalOriginal;


    /**
     * 原有广告位访问UV
     */
    private Long sdkUvOriginal;

    /**
     * 原有广告位有效访问pv
     */
    private Long slotEfRequestPvOriginal;

    /**
     * 原有新客访问量
     */
    private Long newRequestUvOriginal;

    /**
     * 原有ip访问量
     */
    private Long ipRequestPvOriginal;

    /**
     * 原有广告消耗（分）
     */
    private Long adConsumeOriginal;

    /**
     * 原有杭州每日广告消耗(分)
     */
    private Long hzAdConsumeOriginal;

    /**
     * 原有霍尔果斯每日广告消耗(分)
     */
    private Long hegsAdConsumeOriginal;

    /**
     * 原有霍城兑捷每日广告消耗(分)
     */
    private Long hcdjAdConsumeOriginal;

    /**
     * 原有现金消耗(分)
     */
    private Long cashConsumeOriginal;

    /**
     * 客户类型 0-- 未选择  1--人工服务   2--自主化标识客户
     */
    private Integer clientType;

    /**
     * 每月曝光数
     */
    private Long exposureCount;

    /**
     * 每月点击数
     */
    private Long clickCount;

    /**
     * 每月点击人数
     */
    private Long clickCountUv;

    /**
     * 结算状态：0-待结算，1-结算中，2-拒绝结算，3-已结算
     */
    private Integer settlementStatus;

    /**
     * 提现单id,来源tb_media_cash_order.id
     */
    private Long cashOrderId;

    /**
     * 提现状态: 0-待提现;1-审核中;2-提现拒绝;3-提现通过;4-已打款
     */
    private Integer cashStatus;

    /**
     * 结算拒绝原因
     */
    private String rejectReason;

    /**
     * 媒体请款清单状态：0:未请款，1:已请款
     */
    private Integer cashRequirementStatus;

    /**
     * 媒体运营
     */
    private String mediaOperation;

    /**
     * 风控运营
     */
    private String riskControlOperation;

    /**
     * 媒体运营结算时间
     */
    private Date cashTime;

    /**
     * 风控运营审核时间
     */
    private Date auditTime;

    /**
     * 杭州提现单id
     */
    private Long hzCashOrderId;

    /**
     * 霍尔果斯提现单id
     */
    private Long hegsCashOrderId;

    /**
     * 杭州提现状态
     */
    private Integer hzCashStatus;

    /**
     * 霍尔果斯提现状态
     */
    private Integer hegsCashStatus;


    /**
     * 霍城兑捷提现单id
     */
    private Long hcdjCashOrderId;

    /**
     * 霍城兑捷提现状态
     */
    private Integer hcdjCashStatus;

    /**
     * 杭州预结算单号
     */
    private Long hzPreSettleOrderId;

    /**
     * 霍尔果斯预结算单号
     */
    private Long hegsPreSettleOrderId;

    /**
     * 霍城兑捷预结算单id
     */
    private Long hcdjPreSettleOrderId;

    /**
     * 杭州预结算状态
     */
    private Integer hzPreSettleStatus;

    /**
     * 霍尔果斯预结算状态
     */
    private Integer hegsPreSettleStatus;

    /**
     * 霍城兑捷预结算状态
     */
    private Integer hcdjPreSettleStatus;

    /**
     * 是否已结算0未结算 1已结算
     */
    private Integer settled;

}
