package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 今日流量调整
 */
@Data
public class SlotFlowConfigDTO implements Serializable {

    private static final long serialVersionUID = 4196660194327254477L;


    private Long id;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 计费方式（0:分成 1:CPC 2:CPM 3:UV单价 4:CPT）
     */
    private Integer chargeType;

    /**
     * 流量调整比例
     */
    private Integer currentRatio;

    /**
     * 昨日访问PV
     */
    private Long slotEfRequestPvCount;

    /**
     * 昨日原有访问PV
     */
    private Long slotEfRequestPvCountOriginal;

    /**
     * 昨日现金总消耗
     */
    private Long cashConsume;

    /**
     * 昨日原有现金消耗
     */
    private Long cashConsumeOriginal;

    /**
     * 修改时间
     */
    private Date gmtModified;
}

