package cn.com.duiba.tuia.ssp.center.api.dto.advertiser;

import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author shenjiaqing
 * @description
 * @data 2020/3/24
 */
@Data

public class AdvertiserThreePartyAuditStatusEntity extends BaseQueryReq {

    private static final long serialVersionUID = -1493521786368734343L;

    private Long id;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     * 第三方广告主id
     */
    private Long threePartyAdvertiserId;

    /**
     * adx类型
     */
    private Integer adxType;

    /**
     * 审核状态
     */
    @NotNull(message = "审核状态不能为空")
    private Integer auditStatus;

    /**
     * 审核理由
     */
    private String remark;

    /**
     * 审核日期
     */
    private Date auditOn;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;
}
