/**
 * Project Name:ssp-center-api
 * File Name:RemoteStrategyService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年6月6日上午10:55:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqStrategyPageQuery;
import cn.com.duiba.tuia.ssp.center.api.dto.ShieldStrategyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;

/**
 * ClassName:RemoteStrategyService <br/>
 * Function: 屏蔽策略. <br/>
 * Date:     2017年6月6日 上午10:55:20 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteStrategyService {

    DubboResult<ShieldStrategyDto> selectShieldStrategyById(Long id);

    DubboResult<ShieldStrategyDto> insert(ShieldStrategyDto record);

    DubboResult<Integer> update(ShieldStrategyDto record);

    DubboResult<Integer> deleteInBiz(Long id);

    DubboResult<List<ShieldStrategyDto>> selectListByMediaId(Long mediaId);

    DubboResult<List<ShieldStrategyDto>> selectListByPage(ReqStrategyPageQuery reqStrategyPageQuery);

    DubboResult<Integer> selectAmountByPage(Long mediaId, String strategyName);

    DubboResult<Integer> selectListByPageAmount(ReqStrategyPageQuery req);

    DubboResult<List<Long>> selectIdByName(Long mediaId, String strategyName);

    DubboResult<Boolean> deleteStrategyCache(Long strategyId);
}

