/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    public static final String DEFAULT_FORMATTER = "yyyy-MM-dd HH:mm:ss";

    public static List<String> getBetweenDate(String startDateStr, String endDateStr) {
        try {
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate startDate = LocalDate.parse(startDateStr, pattern);
            LocalDate endDate = LocalDate.parse(endDateStr, pattern);
            ArrayList<String> result = new ArrayList<String>();
            while (startDate.compareTo(endDate) <= 0) {
                result.add(startDate.format(pattern));
                startDate = startDate.plusDays(1L);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u65e5\u671f\u89e3\u6790\u5f02\u5e38\uff0cstartDate:" + startDateStr + ", endDate:" + endDateStr, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static List<String> getBetweenDate(Date startDate, Date endDate) {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDateTime localStartDateStr = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime localEndDateStr = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        ArrayList<String> result = new ArrayList<String>();
        while (localStartDateStr.compareTo(localEndDateStr) <= 0) {
            result.add(localStartDateStr.format(pattern));
            localStartDateStr = localStartDateStr.plusDays(1L);
        }
        return result;
    }

    public static String YYYY_MM_DD(LocalDate date) {
        return DateUtil.YYYY_MM_DD(date, 0);
    }

    public static String YYYY_MM_DD(LocalDate date, int add) {
        String pattern = "yyyy-MM-dd";
        return DateUtil.getDateString(date, add, pattern);
    }

    public static String YYYYMMDD(LocalDate date) {
        return DateUtil.YYYYMMDD(date, 0);
    }

    public static String YYYYMMDD(LocalDate date, int add) {
        String pattern = "yyyyMMdd";
        return DateUtil.getDateString(date, add, pattern);
    }

    private static String getDateString(LocalDate date, int add, String pattern) {
        return date.plusDays(add).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static Date getDate(LocalDate date, int add) {
        LocalDate localDate = date.plusDays(add);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static int getTodayResidualSeconds() {
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        Long seconds = Duration.between(LocalDateTime.now(), todayEnd).toMillis() / 1000L;
        return seconds.intValue();
    }
}

