/**
 * Project Name:ssp-center-api
 * File Name:RemoteSlotActivityService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年12月13日下午3:45:10
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivitySlotDataByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotActivityDataSourceDto;

/**
 * ClassName:RemoteSlotActivityService <br/>
 * Function: 广告位活动每日数据. <br/>
 * Date:     2017年12月13日 下午3:45:10 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteSlotActivityDailyStatisticsService {
    
    /**
     * 
     * getSlotActivityStatList:(查询广告位下活动数据). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    List<SlotActivityDataSourceDto> getSlotActivityStatList(ReqActivitySlotDataByPage param);
    
    /**
     * 
     * getSlotActivityStatCount:(查询广告位下活动数量). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    Integer getSlotActivityStatCount(ReqActivitySlotDataByPage param);
    
    /**
     * 
     * getSlotActivityStatSum:(查询广告位活动数据总计). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    SlotActivityDataSourceDto getSlotActivityStatSum(ReqActivitySlotDataByPage param);
    
    /**
     * 
     * getSlotActivityStatSum:(查询广告位活动每日数据). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    List<SlotActivityDataSourceDto> getSlotActivityStatDaily(ReqActivitySlotDataByPage param);
    
    /**
     * 
     * getSlotActivityStatDailyCount:(查询广告位下活动每日数据数量). <br/>
     *
     * @author guyan
     * @param param
     * @return
     */
    Integer  getSlotActivityStatDailyCount(ReqActivitySlotDataByPage param);
    
}

