package cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.response;

import cn.com.duiba.tuia.ssp.center.api.remote.media.enums.ResultEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 响应结果 Response
 * @dateTime 2019-11-19 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class ResultResponse<T> implements Serializable {

    /*
     * 响应码
     */
    private Integer code;

    /*
     * 响应描述
     */
    private String desc;

    /*
     * 响应结果
     */
    private T data;


    public ResultResponse(ResultEnum resultEnum) {
        this.code = resultEnum.code();
        this.desc = resultEnum.remark();
    }

    public ResultResponse(ResultEnum resultEnum, String desc) {
        this.code = resultEnum.code();
        this.desc = desc;
    }

    public ResultResponse(ResultEnum resultEnum, T data) {
        this.code = resultEnum.code();
        this.desc = resultEnum.remark();
        this.data = data;
    }

    public ResultResponse(ResultEnum resultEnum, String desc, T data) {
        this.code = resultEnum.code();
        this.desc = desc;
        this.data = data;
    }

}
