package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSettled;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSettledProgress;
import cn.com.duiba.tuia.ssp.center.api.dto.SettledDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.SettledPrewarningDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMediaSettlementService {

    /***
     * 查询结算单列表
     */
    List<SettledDTO> listSettled(ReqSettled req);

    /***
     * 查询结算单列表数目
     */
    int countSettled(ReqSettled req);

    /**
     * 新增结算单
     */
    int saveSettled(SettledDTO settledDTO);

    /**
     * 编辑结算单
     */
    int editSettled(SettledDTO settledDTO);

    /**
     * 删除结算单
     */
    int removeSettled(Long id);

    /**
     * 批量保存预警
     */
    int saveBatchSettlementPrewarning(List<SettledPrewarningDTO> prewarningList);

    /**
     * 查询结算单
     */
    SettledDTO getSettled(Long id);

    /**
     * 查询预警内容
     */
    List<SettledPrewarningDTO> listSettlementPrewarning(ReqSettledProgress req);

    /**
     * 查询各类型最新预警内容
     */
    List<SettledPrewarningDTO> listLastSettlementPrewarning(List<Long> mediaIds);
}

