package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 更换活动
 *
 * @author zhangzhenghe
 * @since 2020-02-19 4:52 PM
 */
@Data
public class ActivityReplaceDTO implements Serializable {

    private static final long serialVersionUID = 2388812836197238511L;

    /**
     * 活动投放方式(0:依次投放活动 1:定时投放活动 2:依次投放活动组-定时 3:依次投放活动组-比例)
     */
    private Integer activityPutWay;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * ID
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 被替换的活动ID
     */
    private Long replaceActivityId;

    /**
     * 活动组ID
     */
    private Long actGroupId;

    /**
     * 活动来源
     */
    private Integer source;

    /**
     * 地域类型ID
     */
    private Long regionId;

    /**
     * 所属活动组
     */
    private Byte belongToGroup;

    /**
     * 删除深度广告位
     */
    private Map<String, Object> removedDeepMap;

    /**
     * 新增深度广告位
     */
    private Map<String, Object> addDeepMap;

    /**
     * 活动类型
     */
    Map<Integer, String> actTypeMap;

    /**
     * 活动明细
     */
    List<ReqIdAndType> idAndTypes;

    /**
     * 生效时间
     */
    private String releaseTime;

    /**
     * 计划类型
     */
    private Integer planType;

    /**
     * 被替换的活动类型
     */
    private Integer replaceActivityType;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 流量比例
     */
    private Integer ratio;

    /**
     * 活动归属：0媒体运营,1活动运营
     */
    private Integer belongTo;

    /**
     * 是否默认
     */
    private Integer isDefault;

    /**
     * 排序号
     */
    private Integer sortIndex;

    /**
     * 活动组-定时生效时间
     */
    private String effectTime;
}
