package cn.com.duiba.tuia.ssp.center.api.constant;

public enum CityType {

    FIRST_TIER_CITY("一线城市",1),

    NEW_FIRST_TIER_CITY("新一线城市",0),

    SECOND_TIER_CITY("二线城市",2),

    OTHER("三四五线城市",3);


    /** 城市描述*/
    private String desc;



    /** 类型*/
    private int type;

   CityType(String desc, int type){
        this.desc = desc;
        this.type = type;
    }


    public String getDesc() {
        return desc;
    }

    public int getType() {
        return type;
    }


    /**
     * getTypeByCode:(根据code获取type). <br/>
     * @param code
     * @return int
     */
    public static String getDescByCode(Integer code){
        for(CityType temp:CityType.values()){
            if(code.equals(temp.getType())){
                return temp.getDesc();
            }
        }
        return "未知";
    }
}
