package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 路径枚举类
 */
public enum SsoFieldShieldPathEnum {

    PATH_TYPE_MEDIA_DATA("/appStatistics/mediaData"), //媒体账号media数据

    PATH_TYPE_APP_DATA("/appStatistics/appData"), //媒体数据

    PATH_TYPE_SLOT_DATA("/slotStatistics/slotData"), //广告位数据

    PATH_TYPE_APP_REPORT("/accountReport/appReport"), //媒体日账单

    PATH_TYPE_SLOT_REPORT("/accountReport/slotReport"), //广告位日账单

    PATH_TYPE_SLOT_CONFIG_REPORT("/slot/sensitiveSlotConfig"), //广告位配置

    PATH_TYPE_NO_CHECK_MONTH_REPORT("/accountReport/noCheckMonthReport"), //待结算月账单

    PATH_TYPE_CHECKING_MONTH_REPORT("/accountReport/checkingMonthReport"), //结算中月账单

    PATH_TYPE_CHECKED_MONTH_REPORT("/accountReport/checkedMonthReport"), //已结算月账单

    PATH_TYPE_CHECKED_ECPM_CLICK_PRICE("/accountReport/ecpmAndClickPrice"),//ecpm&活动点击单价

    /**
     * 新增:权限点拆分后,拆为全局维度更细的权限点
     **/
    PATH_AUTH_TICKET_TYPE("/auth/ticketType"), //券类型查看/导出权限

    PATH_AUTH_ADVERT_CONSUME("/auth/advertConsume"), //广告消耗查看/导出权限

    PATH_AUTH_MEDIA_INCOME("/auth/mediaIncome"), //媒体收入查看/导出权限

    PATH_AUTH_CASH_CONSUME("/auth/cashConsume"), //现金消耗查看/导出权限

    PATH_AUTH_CASH_DIVISION_SECTION("/auth/cashDivisionSection"),//现金分成区间查看/导出权限

    PATH_AUTH_DIVISION_PROPORTION("/auth/divisionProportion"),//分成比例查看/导出权限

    PATH_AUTH_ACCOUNT_BALANCE("/auth/accountBalance"),//账户余额查看/导出权限

    PATH_AUTH_ESTIMATE_CONSUME("/auth/estimateConsume"),//预估消耗查看/导出权限

    PATH_AUTH_SETTLE_AMOUNT("/auth/settleAmount"),//结算金额查看/导出权限

    PATH_AUTH_ESTIMATE_SCORE("/auth/estimateScore");//预估分查看/导出权限

    private String path;

    SsoFieldShieldPathEnum(String path) {
        this.path = path;
    }

    public String getPath() {
        return path;
    }




}
