package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/21
 */
public class ReqActivitySlotDto extends BaseQueryDto {

    private static final long serialVersionUID = 295783771480240822L;

    private Long              mediaId;                               //账户id
    private Long              id;                                    // 广告位ID
    private String            name;                                  // 广告位名称
    private Long              appId;                                 // 媒体ID
    private String            appName;                               // 媒体名称
    private List<Long>        idList;                                // 广告位ID列表
    private List<Long>        appIdList;                             // 媒体ID集合

    private String            msName;                                // 广告位规格

    private List<Long>        msIds;                                 // 广告位规格id列表

    private String            slotType;                              // 广告位类型：手动投放、横幅...

    private Integer           isDubious;                             // 是否是可疑广告位

    private Long              tagId;                                 // 广告位标签ID
    private Integer           tagBlock;                              // 标签模块

    private Integer           slotStatus;                            // 广告位状态 0 关闭，1 开启，2 删除，3冻结 不穿默认全部

    private Integer           deleteStatus;                          // 删除状态

    private Integer           frozenStatus;                          // 冻结状态

    private Integer           enableStatus;                          // 开启关闭状态

    private Integer           pageNum;                               // NOSONAR

    private Integer           perSize;                               // NOSONAR

    private Integer           slotAccessType;                        // 接入广告类型 0-互动广告 1-展示广告

    private Integer           sceneType;                             // 广告位类型 1：插屏，2：banner/横幅，3：信息流，6：浮标，7：应用墙，8：开屏，9：自定义场景，10：原生插屏

    private String            title;                                 // 尺寸标题

    private Integer           imageWidth;                            // 宽度

    private Integer           imageHeight;                           //高度

    private Integer           incentiveSwitch;                       // 激励开关(0-关闭，1-默认，2-自定义)

    /**
     * 预警类型(不传则为全部，多选则用逗号分隔 1:活动效益变差 2:优质活动占比需提升 3:长期未更换活动)
     */
    private String            prewarningTypes;

    /**
     * 广告位ID列表
     */
    @JsonIgnore
    private List<Long> slotIds;

    /**
     * 广告位列表
     */
    @JsonIgnore
    private List<RspActivitySlotDto> rspActivitySlotList;

    /**
     * 多个标签则用,分割，大类ID组别ID标签ID之间用-分割，如“5-21-249,5-22-250”
     */
    private String tagIds;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public List<Long> getAppIdList() {
        return appIdList;
    }

    public void setAppIdList(List<Long> appIdList) {
        this.appIdList = appIdList;
    }

    public String getMsName() {
        return msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }

    public List<Long> getMsIds() {
        return msIds;
    }

    public void setMsIds(List<Long> msIds) {
        this.msIds = msIds;
    }

    public String getSlotType() {
        return slotType;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    public Integer getIsDubious() {
        return isDubious;
    }

    public void setIsDubious(Integer isDubious) {
        this.isDubious = isDubious;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Integer getTagBlock() {
        return tagBlock;
    }

    public void setTagBlock(Integer tagBlock) {
        this.tagBlock = tagBlock;
    }

    public Integer getSlotStatus() {
        return slotStatus;
    }

    public void setSlotStatus(Integer slotStatus) {
        this.slotStatus = slotStatus;
    }

    public Integer getPageNum() {
        return super.getCurrentPage();
    }

    public void setPageNum(Integer pageNum) {
        super.setCurrentPage(pageNum);
    }

    public Integer getPerSize() {
        return super.getPageSize();
    }

    public void setPerSize(Integer perSize) {
        super.setPageSize(perSize);
    }

    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public Integer getFrozenStatus() {
        return frozenStatus;
    }

    public void setFrozenStatus(Integer frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    public Integer getIncentiveSwitch() {
        return incentiveSwitch;
    }

    public void setIncentiveSwitch(Integer incentiveSwitch) {
        this.incentiveSwitch = incentiveSwitch;
    }

    public String getPrewarningTypes() {
        return prewarningTypes;
    }

    public void setPrewarningTypes(String prewarningTypes) {
        this.prewarningTypes = prewarningTypes;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public Integer getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Integer getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<RspActivitySlotDto> getRspActivitySlotList() {
        return rspActivitySlotList;
    }

    public void setRspActivitySlotList(List<RspActivitySlotDto> rspActivitySlotList) {
        this.rspActivitySlotList = rspActivitySlotList;
    }

    public String getTagIds() {
        return tagIds;
    }

    public void setTagIds(String tagIds) {
        this.tagIds = tagIds;
    }

    public void handleParam() {
        if(getSlotStatus()==null){
            return;
        }
        switch (getSlotStatus()) {
            case 0: // 关闭
                this.setEnableStatus(0);
                this.setDeleteStatus(0);
                this.setFrozenStatus(0);
                break;
            case 1: // 开启
                this.setEnableStatus(1);
                this.setDeleteStatus(0);
                this.setFrozenStatus(0);
                break;
            case 2: // 删除
                this.setDeleteStatus(1);
                break;
            case 3: // 冻结
                this.setFrozenStatus(1);
                this.setDeleteStatus(0);
                break;
            default:
                break;
        }
    }
}
