package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto;

import cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.enums.DockingStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 媒体清单
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class MediaListing implements Serializable {

    /**
     * 主键 Id
     */
    private Long id;

    /**
     * 媒体 Id
     */
    private String mediaId;

    /**
     * 媒体名称
     */
    private String mediaName;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 访问量级 · 媒体近 7 天日均访问 UV ( 万 )
     */
    private String accessAmount;

    /**
     * 活跃量级 · 应用活跃人数 ( 万 )
     */
    private String activeAmount;

    /**
     * 创建时间
     */
    private String creationTime;

    /**
     * 接入状态
     */
    private String status;

    /**
     * 状态描述
     */
    private String statusDesc;


    public MediaListing(Long id, String appName, String activeAmount, DockingStatusEnum dockingStatus) {
        this.id = id;
        this.appName = appName;
        this.activeAmount = activeAmount;
        this.status = dockingStatus.code();
        this.statusDesc = dockingStatus.remark();
    }

    public MediaListing(Long id, String mediaId, String mediaName, String appName, String accessAmount, String creationTime, DockingStatusEnum dockingStatus) {
        this.id = id;
        this.mediaId = mediaId;
        this.mediaName = mediaName;
        this.appName = appName;
        this.accessAmount = accessAmount;
        this.creationTime = creationTime;
        this.status = dockingStatus.code();
        this.statusDesc = dockingStatus.remark();
    }

}
