package cn.com.duiba.tuia.ssp.center.api.constant.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ExternalPlatformMediaAccountEnum {

    IQIYI(0, "爱奇艺"),
    KUAI_SHOU(1, "快手"),
    ;

    private Integer type;

    private String name;

    public static String getNameByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ExternalPlatformMediaAccountEnum accountEnum : ExternalPlatformMediaAccountEnum.values()) {
            if (accountEnum.type.equals(type)) {
                return accountEnum.name;
            }
        }
        return null;
    }

}