package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainShieldInfoReq;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ShieldDomainDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteShieldDomainService {

    /**
     *
     * @param shieldDomainDto 插入信息，只需要域名和策略名称
     * @return 成功插入行数
     */
    DubboResult<Integer> insert(ShieldDomainDto shieldDomainDto);

    /**
     *
     * @param shieldDomainDto 更新信息，需要域名和策略名称和更新主键ID
     * @return 成功更新条数
     */
    DubboResult<Integer> update(ShieldDomainDto shieldDomainDto);

    /**
     *
     * @param id 屏蔽域名策略主键
     * @return 成功删除行数
     */
    DubboResult<Integer> delete(Long id);

    /**
     *
     * @param domainShieldInfoReq 可以按id精确和策略名称模糊搜索
     * @return
     */
    DubboResult<List<ShieldDomainDto>> selectList(DomainShieldInfoReq domainShieldInfoReq);

    /**
     * 返回分页数据
     * @param domainShieldInfoReq 可以按id精确和策略名称模糊搜索
     * @return
     */
    DubboResult<PageResultDto<ShieldDomainDto>> selectListByPage(DomainShieldInfoReq domainShieldInfoReq);

}
