
/**
 * Project Name:media-api<br>
 * File Name:ReqUpdateSlotStrategy.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.req<br>
 * Date:2016年10月19日下午5:18:28<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: ReqUpdateSlotStrategy <br/>
 * date: 2016年10月19日 下午5:18:28 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqUpdateSlotStrategyFix implements Serializable {

    @ApiModelProperty(value = "业务端屏蔽策略ID", required = false)
    private Long              strategyId;
    
    @ApiModelProperty(value = "管理端屏蔽策略ID", required = false)
    private Long              managerStrategyId;

    /** 屏蔽行业列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽行业列表，中间以逗号隔开", required = false)
    private List<String>      shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告列表，中间以逗号隔开", required = false)
    private List<String>      advertTagNums;

    @ApiModelProperty(value = "屏蔽落地页标签", required = false)
    private List<String>	  promoteTagNums;

    /*** 屏蔽素材标签，中间以逗号隔开.*/
    @ApiModelProperty(value = "屏蔽素材标签", required = false)
    private List<String>       materialTagNums;

    /** 不可见行业列表，中间以逗号隔开. */
    @ApiModelProperty(value = "不可见行业列表，中间以逗号隔开", required = false)
    private List<String> invisibleIndustries;

    /** 不可见广告列表，中间以逗号隔开. */
    @ApiModelProperty(value = "不可见属性标签，中间以逗号隔开", required = false)
    private List<String>            invisibleAdvertTagNums;

    /** 不可见落地页标签，中间以逗号隔开. */
    @ApiModelProperty(value = "不可见落地页标签，中间以逗号隔开", required = false)
    private List<String>            invisiblePromoteTagNums;

    /** 不可见素材标签，中间以逗号隔开. */
    @ApiModelProperty(value = "不可见素材标签，中间以逗号隔开", required = false)
    private List<String>            invisibleMaterialTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告主URL列表， 中间以逗号隔开", required = false)
    private List<String>      shieldAdvertisers;

    /**屏蔽活动标签， 中间以逗号隔开.*/
    @ApiModelProperty(value = "屏蔽活动标签， 中间以逗号隔开", required = false)
    private List<String>      shieldActivitys;


    /** The industry flag. */
//    private Boolean           industryFlag      = false;

    /** The advertiser flag. */
//    private Boolean           advertiserFlag    = false;

    /** The advertTagNums flag. */
    private Boolean           advertTagNumsFlag = false;

	/**The activitys flag.*/
//    private Boolean           activitysFlag=false;

    /**The material flag.*/
//    private Boolean           materialFlag=false;

    @ApiModelProperty(value = "广告位素材标签屏蔽， 中间以逗号隔开", required = false)
    private List<String>      shieldSlotMaterialTags;
    /** 广告位素材标签屏蔽开关 */
    private Integer slotShieldMaterialFlag;

    @ApiModelProperty(value = "广告位活动皮肤标签屏蔽， 中间以逗号隔开", required = false)
    private List<String> shieldActivitySkinTags;
    /** 广告位活动皮肤标签屏蔽开关 */
//    private Boolean shieldActivitySkinFlag;

    /** 广告位id*/
    private Long             slotId;
   

    /**
     * shieldIndustries.
     *
     * @return the shieldIndustries
     * @since JDK 1.6
     */
    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    /**
     * shieldIndustries.
     *
     * @param shieldIndustries the shieldIndustries to set
     * @since JDK 1.6
     */
    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    /**
     * shieldAdvertisers.
     *
     * @return the shieldAdvertisers
     * @since JDK 1.6
     */
    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    /**
     * shieldAdvertisers.
     *
     * @param shieldAdvertisers the shieldAdvertisers to set
     * @since JDK 1.6
     */
    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     * @since JDK 1.6
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     * @since JDK 1.6
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * advertTagNums.
     *
     * @return the advertTagNums
     * @since JDK 1.6
     */
    public List<String> getAdvertTagNums() {
        return advertTagNums;
    }

    /**
     * advertTagNums.
     *
     * @param advertTagNums the advertTagNums to set
     * @since JDK 1.6
     */
    public void setAdvertTagNums(List<String> advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    /**
     * industryFlag.
     *
     * @return the industryFlag
     * @since JDK 1.6
     */
//    public Boolean isIndustryFlag() {
//        return industryFlag;
//    }

    /**
     * industryFlag.
     *
     * @param industryFlag the industryFlag to set
     * @since JDK 1.6
     */
//    public void setIndustryFlag(Boolean industryFlag) {
//        this.industryFlag = industryFlag;
//    }

    /**
     * advertiserFlag.
     *
     * @return the advertiserFlag
     * @since JDK 1.6
     */
//    public Boolean isAdvertiserFlag() {
//        return advertiserFlag;
//    }

    /**
     * advertiserFlag.
     *
     * @param advertiserFlag the advertiserFlag to set
     * @since JDK 1.6
     */
//    public void setAdvertiserFlag(Boolean advertiserFlag) {
//        this.advertiserFlag = advertiserFlag;
//    }

    /**
     * advertTagNumsFlag.
     *
     * @return the advertTagNumsFlag
     * @since JDK 1.6
     */
    public Boolean isAdvertTagNumsFlag() {
        return advertTagNumsFlag;
    }

    /**
     * advertTagNumsFlag.
     *
     * @param advertTagNumsFlag the advertTagNumsFlag to set
     * @since JDK 1.6
     */
    public void setAdvertTagNumsFlag(Boolean advertTagNumsFlag) {
        this.advertTagNumsFlag = advertTagNumsFlag;
    }

    /**
     * shieldActivitys.
     *
     * @return the shieldActivitys
     * @since JDK 1.6
     */
    public List<String> getShieldActivitys() {
		return shieldActivitys;
	}

    /**
     * shieldActivitys.
     *
     * @param shieldActivitys the shieldActivitys to set
     * @since JDK 1.6
     */
	public void setShieldActivitys(List<String> shieldActivitys) {
		this.shieldActivitys = shieldActivitys;
	}

	/**
     * activitysFlag.
     *
     * @return the activitysFlag
     * @since JDK 1.6
     */
//	public Boolean isActivitysFlag() {
//		return activitysFlag;
//	}

	/**
     * activitysFlag.
     *
     * @param activitysFlag the activitysFlag to set
     * @since JDK 1.6
     */
//	public void setActivitysFlag(Boolean activitysFlag) {
//		this.activitysFlag = activitysFlag;
//	}
	
	/**
     * managerStrategyId.
     *
     * @return the managerStrategyId
     * @since JDK 1.6
     */
	public Long getManagerStrategyId() {
	    return managerStrategyId;
	 }

	/**
     * managerStrategyId.
     *
     * @param managerStrategyId the managerStrategyId to set
     * @since JDK 1.6
     */    
	public void setManagerStrategyId(Long managerStrategyId) {
	    this.managerStrategyId = managerStrategyId;
	}
	
	/**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
	public Long getSlotId() {
	    return slotId;
	}

	/**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */      
	public void setSlotId(Long slotId) {
	     this.slotId = slotId;
	}

	public List<String> getPromoteTagNums() {
		return promoteTagNums;
	}

	public void setPromoteTagNums(List<String> promoteTagNums) {
		this.promoteTagNums = promoteTagNums;
	}

    public List<String> getInvisibleIndustries() {
        return invisibleIndustries;
    }

    public void setInvisibleIndustries(List<String> invisibleIndustries) {
        this.invisibleIndustries = invisibleIndustries;
    }

    public List<String> getInvisibleAdvertTagNums() {
        return invisibleAdvertTagNums;
    }

    public void setInvisibleAdvertTagNums(List<String> invisibleAdvertTagNums) {
        this.invisibleAdvertTagNums = invisibleAdvertTagNums;
    }

    public List<String> getInvisiblePromoteTagNums() {
        return invisiblePromoteTagNums;
    }

    public void setInvisiblePromoteTagNums(List<String> invisiblePromoteTagNums) {
        this.invisiblePromoteTagNums = invisiblePromoteTagNums;
    }

    public List<String> getInvisibleMaterialTagNums() {
        return invisibleMaterialTagNums;
    }

    public void setInvisibleMaterialTagNums(List<String> invisibleMaterialTagNums) {
        this.invisibleMaterialTagNums = invisibleMaterialTagNums;
    }

//    public Boolean isMaterialFlag() {
//        return materialFlag;
//    }

//    public void setMaterialFlag(Boolean materialFlag) {
//        this.materialFlag = materialFlag;
//    }

    public List<String> getMaterialTagNums() {
        return materialTagNums;
    }

    public void setMaterialTagNums(List<String> materialTagNums) {
        this.materialTagNums = materialTagNums;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public List<String> getShieldSlotMaterialTags() {
        return shieldSlotMaterialTags;
    }

    public void setShieldSlotMaterialTags(List<String> shieldSlotMaterialTags) {
        this.shieldSlotMaterialTags = shieldSlotMaterialTags;
    }

    public Integer getSlotShieldMaterialFlag() {
        return slotShieldMaterialFlag;
    }

    public void setSlotShieldMaterialFlag(Integer slotShieldMaterialFlag) {
        this.slotShieldMaterialFlag = slotShieldMaterialFlag;
    }

    public List<String> getShieldActivitySkinTags() {
        return shieldActivitySkinTags;
    }

    public void setShieldActivitySkinTags(List<String> shieldActivitySkinTags) {
        this.shieldActivitySkinTags = shieldActivitySkinTags;
    }

//    public Boolean isShieldActivitySkinFlag() {
//        return shieldActivitySkinFlag;
//    }

//    public void setShieldActivitySkinFlag(Boolean shieldActivitySkinFlag) {
//        this.shieldActivitySkinFlag = shieldActivitySkinFlag;
//    }
}
