/**
 * Copyright (c) 2020, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

/**
 * 描述: 素材标签查询
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2020/6/30 13:43
 */
public class MaterialTagDTO implements Serializable {
    private static final long serialVersionUID = -2536109707039427605L;

    private Long materialId;      //素材id

    private String effectType;   //素材效果分类（动态，静态，视频）

    private String figureType;   //素材类型（单图，组图）

    private String customType;   //是否定制

    /* 一下均为标签ID集合 */
    private String materialIndustryTag;   //素材行业标签
    private String slotType;     //广告位性质
    private String materialStrategy;     //优质素材策略
    private String prizeElement; //奖品元素
    private String designColor;  //设计色调
    private String designStyle;  //设计风格
    private String dynamicEffect;  //设计动效
    private String textElement;    //文案元素
    private String activityTool;   //活动工具
    private String season;         //季节标签
    private String festival;       //节日标签
    private String timing;         //时间标签（周末，月初，月中，月末）
    private String scene;          //使用场景

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getEffectType() {
        return effectType;
    }

    public void setEffectType(String effectType) {
        this.effectType = effectType;
    }

    public String getFigureType() {
        return figureType;
    }

    public void setFigureType(String figureType) {
        this.figureType = figureType;
    }

    public String getCustomType() {
        return customType;
    }

    public void setCustomType(String customType) {
        this.customType = customType;
    }

    public String getMaterialIndustryTag() {
        return materialIndustryTag;
    }

    public void setMaterialIndustryTag(String materialIndustryTag) {
        this.materialIndustryTag = materialIndustryTag;
    }

    public String getSlotType() {
        return slotType;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    public String getMaterialStrategy() {
        return materialStrategy;
    }

    public void setMaterialStrategy(String materialStrategy) {
        this.materialStrategy = materialStrategy;
    }

    public String getPrizeElement() {
        return prizeElement;
    }

    public void setPrizeElement(String prizeElement) {
        this.prizeElement = prizeElement;
    }

    public String getDesignColor() {
        return designColor;
    }

    public void setDesignColor(String designColor) {
        this.designColor = designColor;
    }

    public String getDesignStyle() {
        return designStyle;
    }

    public void setDesignStyle(String designStyle) {
        this.designStyle = designStyle;
    }

    public String getDynamicEffect() {
        return dynamicEffect;
    }

    public void setDynamicEffect(String dynamicEffect) {
        this.dynamicEffect = dynamicEffect;
    }

    public String getTextElement() {
        return textElement;
    }

    public void setTextElement(String textElement) {
        this.textElement = textElement;
    }

    public String getActivityTool() {
        return activityTool;
    }

    public void setActivityTool(String activityTool) {
        this.activityTool = activityTool;
    }

    public String getSeason() {
        return season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getFestival() {
        return festival;
    }

    public void setFestival(String festival) {
        this.festival = festival;
    }

    public String getTiming() {
        return timing;
    }

    public void setTiming(String timing) {
        this.timing = timing;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }
}
