package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import java.util.List;
import java.util.Optional;

/**
 * @Auther: fenglijun
 * @Date: 2019/8/8 13:35
 * @Description:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class NewMediaTestDto extends NewMediaTest {


    /**
     * 媒体标签
     */
    private String appTag;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 质量等级
     */
    private String qualityLevel;

    /**
     * 建议行业
     */
    private List<String> suggestIndustry;


    public NewMediaTestDto(NewMediaTest target, String appName, String appTag, String qualityLevel) {
        target = Optional.ofNullable(target).orElseGet(NewMediaTest::new);
        setId(target.getId());
        setAppId(target.getAppId());
        setCurDate(target.getCurDate());
        setGmtCreate(target.getGmtCreate());
        setGmtModified(target.getGmtModified());
        setAppMark(target.getAppMark());
        setTesStatus(target.getTesStatus());
        setPriority(target.getPriority());
        setDataSource(target.getDataSource());
        this.appName = Optional.ofNullable(appName).orElseGet(() -> "-");
        this.appTag = Optional.ofNullable(appTag).orElseGet(() -> "-");
        this.qualityLevel = Optional.ofNullable(qualityLevel).orElseGet(() -> "-");
    }

}
