package cn.com.duiba.tuia.ssp.center.api.dto.externalplatformmedia;

import lombok.Data;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ExternalPlatformMediaAccountDTO extends MediaAccountBaseDTO {

    private static final long serialVersionUID = -8473128946405682672L;

    /**
     * 账号id
     */
    private Long id;

    /**
     * 媒体标识符
     */
    private Integer mediaType;

    /**
     * 媒体名称
     */
    private String mediaName;

    /**
     * 账号名称
     */
    private String accountName;

    /**
     * 余额
     */
    private String balanceStr;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 媒体消耗
     */
    private String mediaConsumeStr;

    /**
     * 现金分成
     */
    private String cashShare;

    /**
     * 分成比例
     */
    private String proportion;

    /**
     * 媒体消耗
     */
    private BigDecimal mediaConsume;

    /**
     * 媒体返点
     */
    private Double mediaRebate;

    /**
     * 入口素材曝光数
     */
    private Long entryMaterialExposureCount;

    /**
     * 入口素材点击数
     */
    private Long entryMaterialClickCount;

    /**
     * 入口素材点击率
     */
    private Double entryMaterialClickRate;

    /**
     * 每千次展示的成本
     */
    private BigDecimal costPerMill;

    /**
     * 每千次展示的成本
     */
    private String costPerMillStr;

    /**
     * 每次点击费用
     */
    private BigDecimal costPerClick;

    /**
     * 每次点击费用
     */
    private String costPerClickStr;

    /**
     * 登录名
     */
    private String loginName;

    /**
     * 登陆密码
     */
    private String loginPassword;

    /**
     * 运营人员
     */
    private String operatorName;

    /**
     * 运营人员id
     */
    private Long operatorId;

    /**
     * 广告位id
     */
    private String slotId;

    /**
     * 广告位id集合
     */
    private List<String> slotIds;

    /**
     * 账户状态:0.冻结 1.正常
     */
    private Integer status;

    /**
     * 是否删除:0.未删除 1.已删除
     */
    private Integer deleteFlag;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 代理名称
     */
    private String agentName;

    /**
     * 开启状态
     * 1、暂停：以媒体消耗为零为准；
     * 2、投放：以媒体消耗大于零为准
     */
    private Integer launchStatus;

    /**
     * 子账号
     */
    private String childrenId;

    public ExternalPlatformMediaAccountDTO() {
    }

    public ExternalPlatformMediaAccountDTO(Long id) {
        this.id = id;
    }

}
