/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;

import java.util.List;

/**
 * 描述: 域名管理查询条件
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/25 10:00
 */
public class DomainCheckManagerQuery extends BaseQueryDto {

    /* 域名名称 */
    private String domainName;
    /* 域名状态 0:初始化；1:正常；2:异常 */
    private Integer domainStatus;
    /* 域名类型 1:投放域名；2:活动域名；3:落地页域名 */
    private Integer domainType;
    /* 域名标签 废弃*/
    private Long domainTag;
    /* 域名标签 废弃 */
    private List<Long> domainTagList;
    /* http类型 1:http;2:https */
    private Integer httpType;
    /* 删除状态 0：未删除，1：删除 */
    private Integer deleted = 0;

    private String domainRecord;

    /**
     * 新标签ID
     */
    private Long tagId;

    /**
     * 新标签ID列表
     */
    private List<Long> tagIdList;
    private List<Long> ids;

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getDomainStatus() {
        return domainStatus;
    }

    public void setDomainStatus(Integer domainStatus) {
        this.domainStatus = domainStatus;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public Long getDomainTag() {
        return domainTag;
    }

    public void setDomainTag(Long domainTag) {
        this.domainTag = domainTag;
    }

    public List<Long> getDomainTagList() {
        return domainTagList;
    }

    public void setDomainTagList(List<Long> domainTagList) {
        this.domainTagList = domainTagList;
    }

    public Integer getHttpType() {
        return httpType;
    }

    public void setHttpType(Integer httpType) {
        this.httpType = httpType;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public String getDomainRecord() {
        return domainRecord;
    }

    public void setDomainRecord(String domainRecord) {
        this.domainRecord = domainRecord;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public List<Long> getTagIdList() {
        return tagIdList;
    }

    public void setTagIdList(List<Long> tagIdList) {
        this.tagIdList = tagIdList;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}
