package cn.com.duiba.tuia.ssp.center.api.dto.mobile;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * 移动智码对接访问信息DTO
 * @author miaohongshuai
*/
@Data
@Builder
public class SmartCodeInfoDTO implements Serializable {

    private static final long serialVersionUID = -8582365533123202132L;
    private String deviceId;
    private Long slotId;
    private Long activityId;

    /** 可选,成功之后，返回用户的唯一id，如果失败，不返回该值。通过发起报文的appToken解析之后关联唯一用户获得*/
    private String uaId;
    /** 必选,本次应答对应的营销位展示ID*/
    private String impId;
    /** 必选,广告物料拉取URL地址*/
    private String advertAdm;
    /** 必选,物料点击后跳转到目的URL*/
    private String clickUrl;
    /** 必选,竞价结果*/
    private Float bidPrice;
    /** 必选,营销位购买者ID*/
    private String buyerId;
    /** 必选,订单生效时间*/
    private String effectedAt;
    /** 必选,订单失效时间*/
    private String expiredAt;
    /** 必选,展示行为第三方监测配置，用于指导植入第三方监测代码*/
    private String showMonitorConfig;
    /** 必选,点击行为第三方监测配置，用于指导植入第三方监测代码*/
    private String clickMonitorConfig;
    /** 必选,订单ID*/
    private String orderId;

    /** 可选,广告标题*/
    private String advertTitle;
    /** 可选,广告内容*/
    private String advertContent;
    /** 运营商类型： （0：移动），（1：电信），（2：联通）*/
    private Integer netChannel;
}
