package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 分成比例审核对象 tb_share_proportion_audit
 * 
 * @author YanfeiAndAHai
 * @date 2021-08-04
 */
@Data
public class ShareProportionAuditDTO extends BaseQueryDto {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;
    /**
     * 主键列表
     */
    private List<Long> ids;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;
    /**
     * 申请开始时间
     */
    private Date applyStartTime;
    /**
     * 申请结束时间
     */
    private Date applyEndTime;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtModified;

    /** 删除标志 0-不删除 1-删除 */
    private Integer isDeleted;

    /** 广告位ID */
    private Long slotId;
    /**
     * 广告位列表
     */
    private List<Long> slotIds;

    /** 广告位名称 */
    private String slotName;

    /** 媒体ID */
    private Long appId;

    /** 媒体名称 */
    private String appName;

    /** 运营负责人ID */
    private String operationPrincipalId;
    /**
     * 运营负责人名称
     */
    private String operationPrincipalNames;

    /** 分控建议计费价格（分成） */
    private Long riskAdviceRate;

    /** 调整申请比例（分成） */
    private Long applyRate;

    /** 调整申请金额（分） */
    private Long applyAmount;

    /** 作弊消耗占比 */
    private Long cheatFeeRate;

    /** 昨日现金总消耗（分） */
    private Long yesterdayCashConsume;

    /** 调整原因 */
    private String adjustReason;

    /** 调整原因ID */
    private Integer adjustReasonId;

    /** 审核状态 1-待审核 2-审核通过 3-审核拒绝 4-超时未审核 5-审核撤销 */
    private Integer auditStatus;
    /**
     * 审核状态列表
     */
    private List<Integer> auditStatusList;

    /** 昨日审核状态 1-空 2-审核通过 3-审核拒绝 4-审核超时 */
    private Integer yesterdayAuditStatus;

    /** 创建人ID */
    private Long creatorId;
    /**
     * 创建人id列表
     */
    private List<Long> creatorIds;

    /** 作弊消耗等级 1:<=10% 2:11%-20%  3:21%-30% 4:31%-40% 5:41%-50% 6:51%-60% 7:61%-70% 8:71%-80% 9:81%-90% 10:91%-100% */
    private Integer cheatFeeLevel;
    /**
     * 申请调整的总金额
     */
    private Long applyAmountTotal;
    /**
     * 已审批通过的调整金额
     */
    private Long applyAmountForPass;
    /**
     * 待审批的调整金额
     */
    private Long applyAmountForPending;
}
