package cn.com.duiba.tuia.ssp.center.api.econtract.dto.bestsign;

import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: 上上签请求响应结果对象
 *
 * @author hillchen
 * @create 2019/1/17 13:44
 */
public class BestsignRequestResult<T> {
    private final static Integer ERRORNO_SUCC = 0;

    /**
     * 异常错误码
     */
    private Integer errno;
    /**
     * 响应结果主体
     */
    private T data;
    /**
     * 请求耗时：毫秒数
     */
    private Long cost;
    /**
     * 异常消息
     */
    private String errmsg;

    public BestsignRequestResult(Integer errno, T data, Long cost, String errmsg) {
        this.errno = errno;
        this.data = data;
        this.cost = cost;
        this.errmsg = errmsg;
    }

    public BestsignRequestResult() {
    }

    public Integer getErrno() {
        return errno;
    }

    public void setErrno(Integer errno) {
        this.errno = errno;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Long getCost() {
        return cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public String getErrmsg() {
        return errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public boolean succResult(){
        return Objects.equals(ERRORNO_SUCC,errno);
    }

}