package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;


/**
 * api打包版本表
 */
@ApiModel
public class ApiVersionDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @ApiModelProperty(value = "api的id号", required = false)
    private Long id;

    /**
     * api版本
     */
    @ApiModelProperty(value = "api版本", required = false)
    private String apiVersion;

    /**
     * api包下载地址
     */
    @ApiModelProperty(value = "api包url", required = false)
    private String apiPackageUrl;

    /**
     * api文档地址
     */
    @ApiModelProperty(value = "doc文档", required = false)
    private String apiDocUrl;

    /**
     * api包PDF文档地址
     */
    @ApiModelProperty(value = "pdf文档", required = false)
    private String apiPdfUrl;

    /**
     * api类型:(0:android;1:ios;2:js)
     */
    @ApiModelProperty(value = "api类型(0:Android;1:iOS;2:js)", required = false)
    private Integer apiType;

    /**
     * 备注
     */
    @ApiModelProperty(value = "api备注信息", required = false)
    @Size(max = 1000, message="备注信息最多只能添加1000个字")
    private String apiRemark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否发布.0:否，1:是
     */
    private Integer isRelease;

    /**
     * 当前版本id
     */
    private Long currentReleaseId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiPackageUrl() {
        return apiPackageUrl;
    }

    public void setApiPackageUrl(String apiPackageUrl) {
        this.apiPackageUrl = apiPackageUrl;
    }

    public String getApiDocUrl() {
        return apiDocUrl;
    }

    public void setApiDocUrl(String apiDocUrl) {
        this.apiDocUrl = apiDocUrl;
    }

    public String getApiPdfUrl() {
        return apiPdfUrl;
    }

    public void setApiPdfUrl(String apiPdfUrl) {
        this.apiPdfUrl = apiPdfUrl;
    }

    public Integer getApiType() {
        return apiType;
    }

    public void setApiType(Integer apiType) {
        this.apiType = apiType;
    }

    public String getApiRemark() {
        return apiRemark;
    }

    public void setApiRemark(String apiRemark) {
        this.apiRemark = apiRemark;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getIsRelease() {
        return isRelease;
    }

    public void setIsRelease(Integer isRelease) {
        this.isRelease = isRelease;
    }

    public Long getCurrentReleaseId() {
        return currentReleaseId;
    }

    public void setCurrentReleaseId(Long currentReleaseId) {
        this.currentReleaseId = currentReleaseId;
    }


}

