/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 类描述: 域名管理
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2018-01-24
 * @since 1.0
 */
public class DomainCheckManagerDto implements Serializable {

    private Long id;
    /**
     * 域名名称
     */
    private String domainName;

    /**
     * 域名类型；1:投放域名；2:活动域名；3:落地页域名；4:游戏域名;默认为1
     */
    private Integer domainType;

    /**
     * 旧标签，废弃
     */
    private Long domainTag;

    /**
     * 域名类型 0:http;1:https
     */
    private Integer httpType;

    /**
     * 域名场景屏蔽状态；we_chat,qq,alipay,360,chrome等
     */
    private String domainSceneStatus;

    /**
     * 域名状态；0:初始化；1:正常；2:异常
     */
    private Integer domainStatus;

    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Integer deleted;
    private Date gmtCreate;
    private Date gmtModified;

    /**
     * 域名icp备案号
     */
    private String domainRecord;

    /**
     * 备案状态；0:初始化；1:正常；2:异常
     */
    private Integer domainRecordStatus;

    /**
     * DNS解析状态；0:初始化；1:正常；2:异常
     */
    private Integer domainDnsStatus;

    /**
     * HTTPS证书状态；0:初始化；1:正常；2:异常
     */
    private Integer domainHttpsStatus;

    /**
     * CDN状态；0:初始化；1:正常；2:异常
     */
    private Integer domainCdnStatus;

    /**
     * 模拟访问状态；0:初始化；1:正常；2:异常
     */
    private Integer domainAccessStatus;

    /**
     * 备案主体
     */
    private String domainRecordBody;

    /**
     * 标签名称
     */
    private String domainTagName;

    /**
     * 访问UV
     */
    private Long sdkUv;

    /**
     * 消耗
     */
    private Long adConsume;

    /**
     * 告警时间
     */
    private String alertTime;

    /**
     * 新标签ID
     */
    private Long tagId;

    /**
     * 大类ID组别ID标签ID之间用-分割，如“5-21-249,5-22-250”
     */
    private String tagIds;

    /**
     * 备注
     */
    private String domainRemark;

    private List<Long> tagIdList;

    /**
     * 当前域名被屏蔽的url后缀
     */
    private String shieldUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public Long getDomainTag() {
        return domainTag;
    }

    public void setDomainTag(Long domainTag) {
        this.domainTag = domainTag;
    }

    public Integer getHttpType() {
        return httpType;
    }

    public void setHttpType(Integer httpType) {
        this.httpType = httpType;
    }

    public String getDomainSceneStatus() {
        return domainSceneStatus;
    }

    public void setDomainSceneStatus(String domainSceneStatus) {
        this.domainSceneStatus = domainSceneStatus;
    }

    public Integer getDomainStatus() {
        return domainStatus;
    }

    public void setDomainStatus(Integer domainStatus) {
        this.domainStatus = domainStatus;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getDomainRecord() {
        return domainRecord;
    }

    public void setDomainRecord(String domainRecord) {
        this.domainRecord = domainRecord;
    }

    public Integer getDomainRecordStatus() {
        return domainRecordStatus;
    }

    public void setDomainRecordStatus(Integer domainRecordStatus) {
        this.domainRecordStatus = domainRecordStatus;
    }

    public Integer getDomainDnsStatus() {
        return domainDnsStatus;
    }

    public void setDomainDnsStatus(Integer domainDnsStatus) {
        this.domainDnsStatus = domainDnsStatus;
    }

    public Integer getDomainHttpsStatus() {
        return domainHttpsStatus;
    }

    public void setDomainHttpsStatus(Integer domainHttpsStatus) {
        this.domainHttpsStatus = domainHttpsStatus;
    }

    public Integer getDomainCdnStatus() {
        return domainCdnStatus;
    }

    public void setDomainCdnStatus(Integer domainCdnStatus) {
        this.domainCdnStatus = domainCdnStatus;
    }

    public Integer getDomainAccessStatus() {
        return domainAccessStatus;
    }

    public void setDomainAccessStatus(Integer domainAccessStatus) {
        this.domainAccessStatus = domainAccessStatus;
    }

    public String getDomainRecordBody() {
        return domainRecordBody;
    }

    public void setDomainRecordBody(String domainRecordBody) {
        this.domainRecordBody = domainRecordBody;
    }

    public String getDomainTagName() {
        return domainTagName;
    }

    public void setDomainTagName(String domainTagName) {
        this.domainTagName = domainTagName;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getAdConsume() {
        return adConsume;
    }

    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume;
    }

    public String getAlertTime() {
        return alertTime;
    }

    public void setAlertTime(String alertTime) {
        this.alertTime = alertTime;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public String getTagIds() {
        return tagIds;
    }

    public void setTagIds(String tagIds) {
        this.tagIds = tagIds;
    }

    public String getDomainRemark() {
        return domainRemark;
    }

    public void setDomainRemark(String domainRemark) {
        this.domainRemark = domainRemark;
    }

    public List<Long> getTagIdList() {
        return tagIdList;
    }

    public void setTagIdList(List<Long> tagIdList) {
        this.tagIdList = tagIdList;
    }

    public String getShieldUrl() {
        return shieldUrl;
    }

    public void setShieldUrl(String shieldUrl) {
        this.shieldUrl = shieldUrl;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
