package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPluginSetDTO;
import cn.com.duiba.tuia.ssp.center.api.params.SdkVerifyRecordParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteTuiaPluginSetService {

    List<TuiaSdkPluginSetDTO> listAll();

    List<TuiaSdkPluginSetDTO> queryAll();

    Boolean addPluginSet(TuiaSdkPluginSetDTO pluginSet) throws BizException;

    Boolean updatePluginSet(TuiaSdkPluginSetDTO tuiaSdkPluginSetDTO) throws BizException;

    Boolean rollbackPluginSet(TuiaSdkPluginSetDTO tuiaSdkPluginSetDTO) throws BizException;

    Boolean grayToFull(TuiaSdkPluginSetDTO tuiaSdkPluginSetDTO) throws BizException;

    Boolean grayClose(TuiaSdkPluginSetDTO tuiaSdkPluginSetDTO) throws BizException;

    Boolean deletePluginSet(Long id, String modifier) throws BizException;

    TuiaSdkPluginSetDTO getById(Long id) throws BizException;

    Boolean updateVerifyStatus(SdkVerifyRecordParam param) throws BizException;

    Boolean updateCheckStatus(SdkVerifyRecordParam param) throws BizException;

    List<TuiaSdkPluginSetDTO> listByPluginVersionCode(Long pluginVersionCode);

    List<TuiaSdkPluginSetDTO> listByAppKey(String appKey);

    List<TuiaSdkPluginSetDTO> listByAppKeyAndSdkVersionCode(String appKey, Long sdkVersionCode);

    List<TuiaSdkPluginSetDTO> listBySdkVersionCode(Long versionCode);
}
