/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum DomainSceneType {
    WE_CHAT(1, "WE_CHAT", "\u5fae\u4fe1\u70b9\u51fb"),
    QQ(2, "CLIENT_QQ", "QQ"),
    ALIPAY(3, "ALIPAY", "\u652f\u4ed8\u5b9d"),
    BROWSER_QQ(4, "BROWSER_QQ", "QQ\u6d4f\u89c8\u5668"),
    BROWSER_360(5, "BROWSER_360", "360\u6d4f\u89c8\u5668"),
    WECHAT_SCAN(6, "WECHAT_SCAN", "\u5fae\u4fe1\u626b\u7801");

    private Integer type;
    private String code;
    private String desc;

    private DomainSceneType(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static DomainSceneType getByCode(String code) {
        for (DomainSceneType e : DomainSceneType.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return WE_CHAT;
    }

    public static String getMatchApolloScene(String sceneEnum) {
        if (StringUtils.isEmpty((CharSequence)sceneEnum)) {
            return "";
        }
        if (Objects.equals(sceneEnum, "WX_CLICK")) {
            return "WE_CHAT";
        }
        if (Objects.equals(sceneEnum, "ALI_PAY")) {
            return "ALIPAY";
        }
        if (Objects.equals(sceneEnum, "WX_SCAN")) {
            return "WECHAT_SCAN";
        }
        return "";
    }
}

