package cn.com.duiba.tuia.ssp.center.api.dto;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.List;

/**
 * ClassName:ReqMaterialDto <br/>
 * Function: 素材库查询. <br/>
 * Date:     2017年7月12日 下午3:51:36 <br/>
 * @author   guyan
 * @version
 * @since    JDK 1.6
 * @see
 */
public class ReqMaterialDto extends BaseQueryDto {

    private static final long serialVersionUID = -6871234214516166275L;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "统计数据开始日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String dataStartDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "统计数据结束日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String dataEndDate;

    private Long id;

    private String title;

    private Long msId;

    private String pictureGroup;

    private String pictureType;

    private String designer;

    private List<ReqMsChildDto> content;

    private String md5;

    private String msContent;

    private String pictureVal;

    private String fingerPrint;

    private  Integer isFather;

    private  Long pid;

    private Long tagId;

    /**
     * 改为支持多标签搜索，之所以不替换tagId是防止上层有其他接口使用tagId
     */
    private List<Long> tagIds;

    /**
     * 多标签搜索是否取交集.
     */
    private Boolean tagsTakeIntersection;

    /** 搜索限制条件：素材id列表 */
    private List<Long> idList;

    /** 素材开启状态，0：关闭，1：开启，不传：全部 */
    private Integer enableStatus;

    /** 广告位ID */
    private long slotId;

    /** 素材宽 */
    private Integer width;

    /** 素材高 */
    private Integer height;

    /** 素材大小 */
    private Long pictureSize;

    /** 素材文案-标题 */
    private String extTitle;
    /** 素材文案-描述 */
    private String extDesc;
    /** 广告位素材类型 */
    private Integer sckType;

    /** 是否显示相近尺寸素材，0：不显示，1：显示 */
    private Integer showSimilar;

    /** 是否添加至优选库(-1:全部素材 1:已添加 0:未添加) **/
    private Integer preferredStatus;

    /** 素材类型（1:单图 2:组图） */
    private Integer materialType;

    /**
     * 素材格式类型（0：普通类型 1：SVGA类型
     */
    private Integer formatType;

    /** 搜索限制条件：父素材id列表 */
    private List<Long> pidList;

    /**
     * 是否属于adx素材
     */
    private Integer isAdx;

    /**
     * adx素材比例区间
     */
    private Integer ratioType;

    /**
     * adx素材来源， 1：adx-人工素材 2：adx-算法素材 3：大盘素材
     */
    private Integer materialSource;

    /** 关联动效ID
     */
    private Long dynamicEffectId;

    /**
     * 尺寸标题
     */
    private String sizeTitle;

    public List<ReqMsChildDto> getContent() {
        return content;
    }

    public void setContent(List<ReqMsChildDto> content) {
        this.content = content;
    }

    public String getPictureVal() {
        if(StringUtils.isNotBlank(this.msContent)){
            List<MCDto> mcDtoList = JSONObject.parseArray(this.msContent, MCDto.class);
            for (MCDto mdl : mcDtoList) {
                this.pictureVal=mdl.getHeight() + "*" + mdl.getWidth();
            }
        }
        return pictureVal;
    }

    public void setPictureVal(String pictureVal) {
        this.pictureVal = pictureVal;
    }

    public String getMsContent() {
        return msContent;
    }

    public void setMsContent(String msContent) {
        this.msContent = msContent;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public String getPictureGroup() {
        return pictureGroup;
    }

    public void setPictureGroup(String pictureGroup) {
        this.pictureGroup = pictureGroup;
    }

    public String getPictureType() {
        return pictureType;
    }

    public void setPictureType(String pictureType) {
        this.pictureType = pictureType;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    @Override
    public String toString() {
        return "ReqMaterialDto{" +
                "id=" + id +
                ", msContent='" + msContent + '\'' +
                ", pictureVal='" + pictureVal + '\'' +
                '}';
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public List<Long> getIdList() {
        return idList;
    }

    public void setIdList(List<Long> idList) {
        this.idList = idList;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public long getSlotId() {
        return slotId;
    }

    public void setSlotId(long slotId) {
        this.slotId = slotId;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Long getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(Long pictureSize) {
        this.pictureSize = pictureSize;
    }

    public String getExtTitle() {
        return extTitle;
    }

    public void setExtTitle(String extTitle) {
        this.extTitle = extTitle;
    }

    public String getExtDesc() {
        return extDesc;
    }

    public void setExtDesc(String extDesc) {
        this.extDesc = extDesc;
    }

    public Integer getSckType() {
        return sckType;
    }

    public void setSckType(Integer sckType) {
        this.sckType = sckType;
    }

    public Integer getShowSimilar() {
        return showSimilar;
    }

    public void setShowSimilar(Integer showSimilar) {
        this.showSimilar = showSimilar;
    }

    public Integer getPreferredStatus() {
        return preferredStatus;
    }

    public void setPreferredStatus(Integer preferredStatus) {
        this.preferredStatus = preferredStatus;
    }

    public String getFingerPrint() {
        return fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public Integer getIsFather() {
        return isFather;
    }

    public void setIsFather(Integer isFather) {
        this.isFather = isFather;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public List<Long> getPidList() {
        return pidList;
    }

    public void setPidList(List<Long> pidList) {
        this.pidList = pidList;
    }

    public Integer getFormatType() {
        return formatType;
    }

    public void setFormatType(Integer formatType) {
        this.formatType = formatType;
    }

    public List<Long> getTagIds() {
        return tagIds;
    }

    public void setTagIds(List<Long> tagIds) {
        this.tagIds = tagIds;
    }

    public Boolean getTagsTakeIntersection() {
        return tagsTakeIntersection;
    }

    public void setTagsTakeIntersection(Boolean tagsTakeIntersection) {
        this.tagsTakeIntersection = tagsTakeIntersection;
    }

    public Integer getIsAdx() {
        return isAdx;
    }

    public void setIsAdx(Integer isAdx) {
        this.isAdx = isAdx;
    }

    public Integer getRatioType() {
        return ratioType;
    }

    public void setRatioType(Integer ratioType) {
        this.ratioType = ratioType;
    }

    public Integer getMaterialSource() {
        return materialSource;
    }

    public void setMaterialSource(Integer materialSource) {
        this.materialSource = materialSource;
    }

    public Long getDynamicEffectId() {
        return dynamicEffectId;
    }

    public void setDynamicEffectId(Long dynamicEffectId) {
        this.dynamicEffectId = dynamicEffectId;
    }

    public String getSizeTitle() {
        return sizeTitle;
    }

    public void setSizeTitle(String sizeTitle) {
        this.sizeTitle = sizeTitle;
    }

    public String getDataStartDate() {
        return dataStartDate;
    }

    public void setDataStartDate(String dataStartDate) {
        this.dataStartDate = dataStartDate;
    }

    public String getDataEndDate() {
        return dataEndDate;
    }

    public void setDataEndDate(String dataEndDate) {
        this.dataEndDate = dataEndDate;
    }
}
