package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteExternalRewardStrategyService {

    ExternalScoreConfigDTO getExternalScoreConfig(int type);

    List<ExternalScoreAppDTO> listExternalScoreApp(ReqExternalScoreApp req);

    int countExternalScoreApp(ReqExternalScoreApp req);

    int saveBatchExternalScoreApp(ReqExternalScoreApp req);

    int removeBatchExternalScoreApp(ReqExternalScoreApp req);

    List<ExternalEstimateScoreDTO> listExternalEstimateScore(ReqExternalEstimateScore req);

    int countExternalEstimateScore(ReqExternalEstimateScore req);

    /**
     * @Description  广告位质量分计数
     * @Date 10:17 2020-10-14
     * @Param [req]
     * @return int
     **/
    int countSlotExternalScore(ReqExternalEstimateScore req);

    /**
     * @Description  广告位质量分分页查询
     * @Date 10:17 2020-10-14
     * @Param [req]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.ExternalEstimateScoreDTO>
     **/
    List<ExternalEstimateScoreDTO> listSlotExternalScore(ReqExternalEstimateScore req);

}
