package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 优选素材请求参数
 *
 * @author zhangzhenghe
 * @since 2020-02-04 11:09 AM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReqMaterialPreferred extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -1122014577777908538L;

    /**
     * 素材ID列表
     */
    private List<Long> ids;

    /**
     * 素材ID
     */
    private Long id;

    /**
     * 素材标题
     */
    private String title;

    /**
     * 素材标签ID列表
     */
    private String tagIds;

    /**
     * 素材标签ID列表
     */
    private List<Long> tagIdList;

    /**
     * 素材开启状态，0：关闭，1：开启，不传：全部
     */
    private Integer enableStatus;

    /**
     * 广告位规格ID
     */
    private Long msId;

    /**
     * 素材分类(0:动态素材 1:静态素材 3:视频素材)
     */
    private String pictureType;

    /**
     * 用户ID
     */
    private Long managerId;

    /**
     * 素材格式类型（0：普通类型 1：SVGA类型
     */
    private Integer formatType;

    /**
     * 素材尺寸 如 200*200
     */
    private String pictureVal;

    /**
     * 尺寸标题
     */
    private String sizeTitle;
}
