package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description 媒体节点枚举
 * @Param
 * @return
 **/
@Getter
public enum MediaTypeEnum {
/************************************************快手subType类型***********************************************************************/
    KUAISHOU_PHONE(1, "1", "激活"),
    KUAISHOU_FORM(1, "2", "注册"),
    KUAISHOU_VIEW(1, "3", "付费"),
    KUAISHOU_ACTIVE(1, "5", "活跃"),
    KUAISHOU_ACTIVE_REGISTER(1, "6", "优质用户"),
    KUAISHOU_ACTIVE_PAY(1, "7", "次日留存"),
    KUAISHOU_CONSULT_EFFECTIVE(1, "9", "表单"),
    KUAISHOU_IN_APP_ORDER(1, "10", "完件"),
    KUAISHOU_IN_APP_PAY(1, "11", "授信"),
    KUAISHOU_GAME_ADDICTION(1, "44", "有效线索"),
    KUAISHOU_CUSTOMER_EFFECTIVE(1, "84", "唤起应用"),
    KUAISHOU_COUPON(1, "109", "电话卡激活"),
    KUAISHOU_NEXT_DAY_OPEN(1, "117", "意向确认"),
    KUAISHOU_SHOPPING(1, "118", "微信加粉"),
    KUAISHOU_LOAN_COMPLETION(1, "119", "成交"),

/************************************************广点通subType类型***********************************************************************/

    GAUNGDAINTONG_RESERVATION(10, "RESERVATION", "预约"),
    GAUNGDAINTONG_CONFIRM_EFFECTIVE_LEADS(10, "CONFIRM_EFFECTIVE_LEADS", "有效综合线索"),
    GAUNGDAINTONG_ACTIVATE_APP(10, "ACTIVATE_APP", "激活"),
    GAUNGDAINTONG_START_APP(10, "START_APP", "次日留存"),
    GAUNGDAINTONG_REGISTER(10, "REGISTER", "注册"),
    GAUNGDAINTONG_PURCHASE(10, "PURCHASE", "付费"),
    GAUNGDAINTONG_COMPLETE_ORDER(10, "COMPLETE_ORDER", "下单"),
    GAUNGDAINTONG_APPLY(10, "APPLY", "完件"),
    GAUNGDAINTONG_PRE_CREDIT(10, "PRE_CREDIT", "预授信"),
    GAUNGDAINTONG_CREDIT(10, "CREDIT", "授信"),


/************************************************百度subType类型***********************************************************************/

    BAIDU_CONSULT_BUTTON_CLICK(2, "1", "咨询按钮点击"),
    BAIDU_PHONE_CLICK(2, "2", "电话按钮点击"),
    BAIDU_FORM_SUBMIT(2, "3", "表单提交成功"),
    BAIDU_ACTIVATION(2, "4", "激活"),
    BAIDU_FORM_BUTTON_CLICK(2, "5", "表单按钮点击"),
    BAIDU_DOWNLOAD_BUTTON_CLICK(2, "6", "下载按钮点击"),
    BAIDU_BUY_BUTTON_CLICK(2, "7", "购买按钮点击(支付按钮点击)"),
    BAIDU_APPOINTMENT_BUTTON_CLICK(2, "12", "预约按钮点击"),
    BAIDU_SECOND_ECOMMERCE_ORDER_SUBMIT(2, "14", "二类电商订单提交成功"),
    BAIDU_SINGLE_TABLE_CALL_UP_BUTTON_CLICK(2, "16", "表单调起按钮点击"),
    BAIDU_EFFECTIVE_CLUES(2, "18", "有效线索"),
    BAIDU_APP_REGISTRATION(2, "25", "应用注册"),



/************************************************巨量subType类型***********************************************************************/
    JULIANG_PHONE(8, "phone", "电话拨打"),
    JULIANG_FORM(8, "form", "表单提交"),
    JULIANG_VIEW(8, "view", "关键页面浏览"),
    JULIANG_ACTIVE(8, "active", "激活"),
    JULIANG_ACTIVE_REGISTER(8, "active_register", "注册"),
    JULIANG_ACTIVE_PAY(8, "active_pay", "付费"),
    JULIANG_CONSULT_EFFECTIVE(8, "consult_effective", "有效咨询"),
    JULIANG_IN_APP_ORDER(8, "in_app_order", "app内下单"),
    JULIANG_IN_APP_PAY(8, "in_app_pay", "app内付费"),
    JULIANG_GAME_ADDICTION(8, "game_addiction", "关键行为"),
    JULIANG_CUSTOMER_EFFECTIVE(8, "customer_effective", "有效获客"),
    JULIANG_COUPON(8, "coupon", "卡券领取"),
    JULIANG_NEXT_DAY_OPEN(8, "next_day_open", "次留"),
    JULIANG_SHOPPING(8, "shopping", "商品购买"),
    JULIANG_LOAN_COMPLETION(8, "loan_completion", "完件"),
    JULIANG_LOAN_CREDIT(8, "loan_credit", "授信"),
    JULIANG_CLUE_FORMAL_ORDER(8, "clue_formal_order", "线索-正式成单"),
    JULIANG_SUPPLY_ACTIVE_PAY(8, "supply_active_pay", "付费-新"),
    ;

    private Integer platform;

    private String mediaType;

    private String desc;

    MediaTypeEnum(Integer platform, String mediaType, String desc){
        this.platform = platform;
        this.mediaType = mediaType;
        this.desc = desc;
    }
}
