package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description 外部媒体平台枚举
 * @Param
 * @return
 **/
@Getter
public enum ProgrammaticMediaPlatformEnum {
    /**
     * 快手
     */
    KUAISHOU(1, "快手"),
//    /**
//     * 百度
//     */
    BAIDU(2, "百度"),
//    /**
//     * 趣头条
//     */
//    QUTOUTIAO(3, "趣头条"),
//    /**
//     * 爱奇艺
//     */
//    IQIYI(4, "爱奇艺"),
//    /**
//     * 知乎
//     */
//    ZHIHU(5, "知乎"),
//    /**
//     * 微博
//     */
//    WEIBO(6, "微博"),
//    /**
//     * 网易
//     */
//    WANGYI(7, "网易"),
//    /**
//     * 巨量
//     */
    JULIANG(8, "巨量"),
//    /**
//     * B站
//     */
//    BLIBLI(9, "B站"),
//    /**
//     * 广点通
//     */
    GUANGDAINTONG(10, "广点通"),
//    /**
//     * 极光
//     */
//    JIGUANG(11, "极光"),
//    /**
//     * 凤凰新闻
//     */
//    FENGHUANGXINWEN(12, "凤凰新闻"),
//    /**
//     * oppo
//     */
//    OPPO(13, "oppo"),
//    /**
//     * 美团
//     */
//    MEITUAN(14, "美团"),
//    /**
//     * vivo
//     */
//    VIVO(15, "vivo"),
//    /**
//     * uc
//     */
//    UC(16, "uc"),
    ;

    private Integer platform;

    private String platformName;

    ProgrammaticMediaPlatformEnum(Integer platform, String platformName){
        this.platform = platform;
        this.platformName = platformName;
    }

    public static String getPlatformNameByPlatform(Integer platform){
        for (ProgrammaticMediaPlatformEnum platformEnum : ProgrammaticMediaPlatformEnum.values()){
            if(platformEnum.getPlatform().equals(platform)){
                return platformEnum.getPlatformName();
            }
        }
        return null;
    }
}
