package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import lombok.Data;

import java.io.Serializable;

@Data
public class AccountMonthReportPrePayRsp implements Serializable {

    private Long id;

    /**
     * 月报表Id
     */
    private Long reportId;

    /**
     * 月账单月份
     */
    private String currentDate;

    /**
     * 媒体用户Id
     */
    private Long mediaId;

    /**
     * 账户
     */
    @SensitiveInfo(sensitiveType = SensitiveType.EMAIL)
    private String account;

    /**
     * 媒体appId
     */
    private Long appId;

    /**
     * 媒体app名称
     */
    private String appName;

    /**
     * 主体：0-杭推,1-霍推,2-兑捷
     */
    private Integer companyType;

    /**
     * 调整后月账单金额
     */
    private Long afterAdjustAmount;

    /**
     * 是否获取结算单：0-未获取结算单,1-已获取结算单
     */
    private Integer statementGain;

    /**
     * 结算单是否收到：0-未收到结算单,1-已收到结算单
     */
    private Integer statementReceive;

    /**
     * 财务审核状态：0:驳回 1:待财务审核 2:审核通过
     */
    private Integer auditStatus;

    /**
     * 媒介
     */
    private String mediaManager;

    /**
     * 媒体运营
     */
    private String mediaOwner;

}
