package cn.com.duiba.tuia.ssp.center.api.dto.media;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Jason
 * @since 2021-09-13 10:23 AM
 */
@Data
public class AdvertWhiteDTO implements Serializable {

    private static final long serialVersionUID = -3703595413847318837L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告计划ID
     */
    private Long advertId;

    /**
     * 状态（0:关闭 1:打开）
     */
    private Integer advertStatus;

    /**
     * 投放开始时间
     */
    private String startDate;

    /**
     * 投放结束时间
     */
    private String endDate;

    /**
     * 投放时间段
     */
    private String timePeriod;

    /**
     * 定向地域
     */
    private String regionIds;

    /**
     * 发券次序
     */
    private String requestTimes;

    /**
     * 出价（单位：分）
     */
    private Long price;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gmtModified;

    /**
     * 广告行业
     */
    private String advertIndustry;

    /**
     * AE名称
     */
    private String aeName;

    /**
     * 广告名称
     */
    private String advertName;
}
