package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 常见问题配置菜单
 */
@Data
public class ProblemMenusPageDTO implements Serializable {

    private static final long serialVersionUID = 1166067162295949746L;

    /**
     * 页面类型(1:SDK对接优势 2:我是开发 3:我是运营)'
     */
    private Integer pageType;

    /**
     * 对接类型(1:快速对接 2:IOS SDK对接 3:Android SDK对接 4:API对接 5:JS对接)
     */
    private Integer pageSetupType;

    /**
     * 问题列表
     */
    private List<RspProblemMenus> problemMenusList;

    /**
     * 创建人
     */
    @JsonIgnore
    private String creater;
}
